/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.PathExecLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecUtil {
    private static final NotNullLazyValue<Boolean> hasGkSudo = new PathExecLazyValue("gksudo");
    private static final NotNullLazyValue<Boolean> hasKdeSudo = new PathExecLazyValue("kdesudo");
    private static final NotNullLazyValue<Boolean> hasPkExec = new PathExecLazyValue("pkexec");
    private static final NotNullLazyValue<Boolean> hasGnomeTerminal = new PathExecLazyValue("gnome-terminal");
    private static final NotNullLazyValue<Boolean> hasKdeTerminal = new PathExecLazyValue("konsole");
    private static final NotNullLazyValue<Boolean> hasXTerm = new PathExecLazyValue("xterm");

    private ExecUtil() {
    }

    @NotNull
    public static String loadTemplate(@NotNull ClassLoader loader, @NotNull String templateName, @Nullable Map<String, String> variables) throws IOException {
        InputStream stream = loader.getResourceAsStream(templateName);
        if (stream == null) {
            throw new IOException("Template '" + templateName + "' not found by " + loader);
        }
        String template = FileUtil.loadTextAndClose((Reader)new InputStreamReader(stream, "UTF-8"));
        if (variables == null || variables.size() == 0) {
            return template;
        }
        StringBuilder buffer = new StringBuilder(template);
        for (Map.Entry<String, String> var : variables.entrySet()) {
            String name = var.getKey();
            int pos = buffer.indexOf(name);
            if (pos < 0) continue;
            buffer.replace(pos, pos + name.length(), var.getValue());
        }
        return buffer.toString();
    }

    @NotNull
    public static File createTempExecutableScript(@NotNull String prefix, @NotNull String suffix, @NotNull String content) throws IOException, ExecutionException {
        File tempDir = new File(PathManager.getTempPath());
        File tempFile = FileUtil.createTempFile((File)tempDir, (String)prefix, (String)suffix, (boolean)true, (boolean)true);
        FileUtil.writeToFile((File)tempFile, (byte[])content.getBytes("UTF-8"));
        if (!tempFile.setExecutable(true, true)) {
            throw new ExecutionException("Failed to make temp file executable: " + tempFile);
        }
        return tempFile;
    }

    @NotNull
    public static String getOsascriptPath() {
        return "/usr/bin/osascript";
    }

    @NotNull
    public static String getOpenCommandPath() {
        return "/usr/bin/open";
    }

    @NotNull
    public static String getWindowsShellName() {
        return SystemInfo.isWin2kOrNewer ? "cmd.exe" : "command.com";
    }

    @NotNull
    public static ProcessOutput execAndGetOutput(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        return new CapturingProcessHandler(commandLine).runProcess();
    }

    @Nullable
    public static String execAndReadLine(@NotNull GeneralCommandLine commandLine) {
        try {
            return ExecUtil.readFirstLine(commandLine.createProcess().getInputStream(), commandLine.getCharset());
        }
        catch (ExecutionException ignored) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String readFirstLine(@NotNull InputStream stream, @Nullable Charset cs) {
        try (BufferedReader reader = new BufferedReader(cs == null ? new InputStreamReader(stream) : new InputStreamReader(stream, cs));){
            String string = reader.readLine();
            return string;
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @NotNull
    public static Process sudo(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws ExecutionException, IOException {
        return ExecUtil.sudoCommand(commandLine, prompt).createProcess();
    }

    @NotNull
    private static GeneralCommandLine sudoCommand(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws ExecutionException, IOException {
        GeneralCommandLine sudoCommandLine;
        if (SystemInfo.isUnix && "root".equals(System.getenv("USER"))) {
            return commandLine;
        }
        ArrayList command = ContainerUtil.newArrayList();
        command.add(commandLine.getExePath());
        command.addAll(commandLine.getParametersList().getList());
        if (SystemInfo.isMac) {
            String escapedCommandLine = StringUtil.join((Collection)command, ExecUtil::escapeAppleScriptArgument, (String)" & \" \" & ");
            String escapedScript = "tell current application\n   activate\n   do shell script " + escapedCommandLine + " with administrator privileges without altering line endings\nend tell";
            sudoCommandLine = new GeneralCommandLine(ExecUtil.getOsascriptPath(), "-e", escapedScript);
        } else if (((Boolean)hasGkSudo.getValue()).booleanValue()) {
            ArrayList sudoCommand = ContainerUtil.newArrayList();
            sudoCommand.addAll(Arrays.asList("gksudo", "--message", prompt, "--"));
            sudoCommand.addAll(command);
            sudoCommandLine = new GeneralCommandLine(sudoCommand);
        } else if (((Boolean)hasKdeSudo.getValue()).booleanValue()) {
            ArrayList sudoCommand = ContainerUtil.newArrayList();
            sudoCommand.addAll(Arrays.asList("kdesudo", "--comment", prompt, "--"));
            sudoCommand.addAll(command);
            sudoCommandLine = new GeneralCommandLine(sudoCommand);
        } else if (((Boolean)hasPkExec.getValue()).booleanValue()) {
            command.add(0, "pkexec");
            sudoCommandLine = new GeneralCommandLine(command);
        } else if (SystemInfo.isUnix && ExecUtil.hasTerminalApp()) {
            String escapedCommandLine = StringUtil.join((Collection)command, ExecUtil::escapeUnixShellArgument, (String)" ");
            File script = ExecUtil.createTempExecutableScript("sudo", ".sh", "#!/bin/sh\necho " + ExecUtil.escapeUnixShellArgument(prompt) + "\necho\nsudo -- " + escapedCommandLine + "\nSTATUS=$?\necho\nread -p \"Press Enter to close this window...\" TEMP\nexit $STATUS\n");
            sudoCommandLine = new GeneralCommandLine(ExecUtil.getTerminalCommand("Install", script.getAbsolutePath()));
        } else {
            throw new UnsupportedOperationException("Unsupported OS/desktop: " + SystemInfo.OS_NAME + '/' + SystemInfo.SUN_DESKTOP);
        }
        return sudoCommandLine.withWorkDirectory(commandLine.getWorkDirectory()).withEnvironment(commandLine.getEnvironment()).withParentEnvironmentType(commandLine.getParentEnvironmentType()).withRedirectErrorStream(commandLine.isRedirectErrorStream());
    }

    @NotNull
    public static ProcessOutput sudoAndGetOutput(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws IOException, ExecutionException {
        return ExecUtil.execAndGetOutput(ExecUtil.sudoCommand(commandLine, prompt));
    }

    @NotNull
    private static String escapeAppleScriptArgument(@NotNull String arg) {
        return "quoted form of \"" + arg.replace("\"", "\\\"") + "\"";
    }

    @NotNull
    public static String escapeUnixShellArgument(@NotNull String arg) {
        return "'" + arg.replace("'", "'\"'\"'") + "'";
    }

    public static boolean hasTerminalApp() {
        return SystemInfo.isWindows || SystemInfo.isMac || (Boolean)hasKdeTerminal.getValue() != false || (Boolean)hasGnomeTerminal.getValue() != false || (Boolean)hasXTerm.getValue() != false;
    }

    @NotNull
    public static List<String> getTerminalCommand(@Nullable String title, @NotNull String command) {
        if (SystemInfo.isWindows) {
            title = title != null ? title.replace("\"", "'") : "";
            return Arrays.asList(ExecUtil.getWindowsShellName(), "/c", "start", GeneralCommandLine.inescapableQuote(title), command);
        }
        if (SystemInfo.isMac) {
            return Arrays.asList(ExecUtil.getOpenCommandPath(), "-a", "Terminal", command);
        }
        if (((Boolean)hasKdeTerminal.getValue()).booleanValue()) {
            return Arrays.asList("konsole", "-e", command);
        }
        if (((Boolean)hasGnomeTerminal.getValue()).booleanValue()) {
            return title != null ? Arrays.asList("gnome-terminal", "-t", title, "-x", command) : Arrays.asList("gnome-terminal", "-x", command);
        }
        if (((Boolean)hasXTerm.getValue()).booleanValue()) {
            return title != null ? Arrays.asList("xterm", "-T", title, "-e", command) : Arrays.asList("xterm", "-e", command);
        }
        throw new UnsupportedOperationException("Unsupported OS/desktop: " + SystemInfo.OS_NAME + '/' + SystemInfo.SUN_DESKTOP);
    }

    public static int execAndGetResult(String ... command) throws ExecutionException, InterruptedException {
        assert (command != null && command.length > 0);
        return new GeneralCommandLine(command).createProcess().waitFor();
    }

    public static int execAndGetResult(@NotNull List<String> command) throws ExecutionException, InterruptedException {
        return new GeneralCommandLine(command).createProcess().waitFor();
    }

    public static ProcessOutput execAndGetOutput(@NotNull List<String> command, @Nullable String workDir) throws ExecutionException {
        GeneralCommandLine commandLine = new GeneralCommandLine(command).withWorkDirectory(workDir);
        return new CapturingProcessHandler(commandLine).runProcess();
    }

    public static String execAndReadLine(String ... command) {
        return ExecUtil.execAndReadLine(new GeneralCommandLine(command));
    }

    public static String execAndReadLine(@Nullable Charset charset, String ... command) {
        GeneralCommandLine commandLine = new GeneralCommandLine(command);
        if (charset != null) {
            commandLine = commandLine.withCharset(charset);
        }
        return ExecUtil.execAndReadLine(commandLine);
    }
}

