/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.autodetecting.FacetDetectorRegistry;
import com.intellij.facet.ui.DefaultFacetSettingsEditor;
import com.intellij.facet.ui.FacetEditor;
import com.intellij.facet.ui.MultipleFacetSettingsEditor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetType<F extends Facet, C extends FacetConfiguration> {
    public static final ExtensionPointName<FacetType> EP_NAME = ExtensionPointName.create((String)"com.intellij.facetType");
    @NotNull
    private final FacetTypeId<F> myId;
    @NotNull
    private final String myStringId;
    @NotNull
    private final String myPresentableName;
    @Nullable
    private final FacetTypeId myUnderlyingFacetType;

    public static <T extends FacetType> T findInstance(Class<T> aClass) {
        return (T)((FacetType)EP_NAME.findExtension(aClass));
    }

    public FacetType(@NotNull FacetTypeId<F> id, @NotNull @NonNls String stringId, @NotNull String presentableName, @Nullable FacetTypeId underlyingFacetType) {
        this.myId = id;
        this.myStringId = stringId;
        this.myPresentableName = presentableName;
        this.myUnderlyingFacetType = underlyingFacetType;
    }

    public FacetType(@NotNull FacetTypeId<F> id, @NotNull @NonNls String stringId, @NotNull String presentableName) {
        this(id, stringId, presentableName, null);
    }

    @NotNull
    public final FacetTypeId<F> getId() {
        return this.myId;
    }

    @NotNull
    public final String getStringId() {
        return this.myStringId;
    }

    @NotNull
    public String getPresentableName() {
        return this.myPresentableName;
    }

    @NotNull
    @NonNls
    public String getDefaultFacetName() {
        return this.myPresentableName;
    }

    @Nullable
    public final FacetTypeId<?> getUnderlyingFacetType() {
        return this.myUnderlyingFacetType;
    }

    public void registerDetectors(FacetDetectorRegistry<C> registry) {
    }

    public abstract C createDefaultConfiguration();

    public abstract F createFacet(@NotNull Module var1, String var2, @NotNull C var3, @Nullable Facet var4);

    public boolean isOnlyOneFacetAllowed() {
        return true;
    }

    public abstract boolean isSuitableModuleType(ModuleType var1);

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public DefaultFacetSettingsEditor createDefaultConfigurationEditor(@NotNull Project project, @NotNull C configuration) {
        return null;
    }

    @Nullable
    public MultipleFacetSettingsEditor createMultipleConfigurationsEditor(@NotNull Project project, @NotNull FacetEditor[] editors) {
        return null;
    }
}

