/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.presentation;

import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.fileTypes.DirectoryFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class VirtualFilePresentation {
    public static Icon getIcon(@NotNull VirtualFile vFile) {
        return IconUtil.getIcon(vFile, 0, null);
    }

    public static Icon getIconImpl(@NotNull VirtualFile vFile) {
        Icon icon = TypePresentationService.getService().getIcon(vFile);
        if (icon != null) {
            return icon;
        }
        FileType fileType = vFile.getFileType();
        if (vFile.isDirectory() && vFile.isInLocalFileSystem() && !(fileType instanceof DirectoryFileType)) {
            return PlatformIcons.FOLDER_ICON;
        }
        return fileType.getIcon();
    }
}

