/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaAnonymousClassesHelper {
    private static final Key<ParameterizedCachedValue<Map<PsiAnonymousClass, String>, PsiClass>> ANONYMOUS_CLASS_NAME = Key.create((String)"ANONYMOUS_CLASS_NAME");
    public static final AnonClassProvider ANON_CLASS_PROVIDER = new AnonClassProvider();

    @Nullable
    public static String getName(@NotNull PsiAnonymousClass cls) {
        PsiClass upper = PsiTreeUtil.getParentOfType((PsiElement)cls, PsiClass.class);
        if (upper == null) {
            return null;
        }
        ParameterizedCachedValue<Map<PsiAnonymousClass, String>, PsiClass> value = (ParameterizedCachedValue<Map<PsiAnonymousClass, String>, PsiClass>)upper.getUserData(ANONYMOUS_CLASS_NAME);
        if (value == null) {
            value = CachedValuesManager.getManager(upper.getProject()).createParameterizedCachedValue(ANON_CLASS_PROVIDER, false);
            upper.putUserData(ANONYMOUS_CLASS_NAME, value);
        }
        return (String)((Map)value.getValue(upper)).get(cls);
    }

    private static class AnonClassProvider
    implements ParameterizedCachedValueProvider<Map<PsiAnonymousClass, String>, PsiClass> {
        private AnonClassProvider() {
        }

        @Override
        public CachedValueProvider.Result<Map<PsiAnonymousClass, String>> compute(final PsiClass upper) {
            THashMap map = new THashMap();
            upper.accept(new JavaRecursiveElementWalkingVisitor((Map)map){
                int index;
                final /* synthetic */ Map val$map;
                {
                    this.val$map = map;
                }

                @Override
                public void visitAnonymousClass(PsiAnonymousClass aClass) {
                    if (upper == aClass) {
                        super.visitAnonymousClass(aClass);
                        return;
                    }
                    PsiExpressionList arguments = aClass.getArgumentList();
                    if (arguments != null) {
                        for (PsiExpression expression : arguments.getExpressions()) {
                            expression.acceptChildren(new JavaRecursiveElementVisitor(){

                                @Override
                                public void visitAnonymousClass(PsiAnonymousClass aClass) {
                                    ++index;
                                    val$map.put(aClass, "$" + index);
                                }
                            });
                        }
                    }
                    ++this.index;
                    this.val$map.put(aClass, "$" + this.index);
                }

                @Override
                public void visitClass(PsiClass aClass) {
                    if (aClass == upper) {
                        super.visitClass(aClass);
                    }
                }
            });
            return CachedValueProvider.Result.create(map, upper);
        }
    }
}

