/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.diagnostic.ImplementationConflictException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Language
extends UserDataHolderBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.Language");
    private static final Map<Class<? extends Language>, Language> ourRegisteredLanguages = ContainerUtil.newConcurrentMap();
    private static final ConcurrentMap<String, List<Language>> ourRegisteredMimeTypes = ContainerUtil.newConcurrentMap();
    private static final Map<String, Language> ourRegisteredIDs = ContainerUtil.newConcurrentMap();
    private final Language myBaseLanguage;
    private final String myID;
    private final String[] myMimeTypes;
    private final List<Language> myDialects = ContainerUtil.createLockFreeCopyOnWriteList();
    public static final Language ANY = new Language(""){

        @Override
        public String toString() {
            return "Language: ANY";
        }

        @Override
        @Nullable
        public LanguageFileType getAssociatedFileType() {
            return null;
        }
    };

    protected Language(@NotNull String ID) {
        this(ID, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    protected Language(@NotNull String ID, String ... mimeTypes) {
        this((Language)null, ID, mimeTypes);
    }

    protected Language(@Nullable Language baseLanguage, @NotNull String ID, String ... mimeTypes) {
        this.myBaseLanguage = baseLanguage;
        this.myID = ID;
        this.myMimeTypes = mimeTypes;
        Class<?> langClass = ((Object)((Object)this)).getClass();
        Language prev = ourRegisteredLanguages.put(langClass, this);
        if (prev != null) {
            throw new ImplementationConflictException("Language of '" + langClass + "' is already registered: " + (Object)((Object)prev), null, new Object[]{prev, this});
        }
        prev = ourRegisteredIDs.put(ID, this);
        if (prev != null) {
            throw new ImplementationConflictException("Language with ID '" + ID + "' is already registered: " + ((Object)((Object)prev)).getClass(), null, new Object[]{prev, this});
        }
        for (String mimeType : mimeTypes) {
            if (StringUtil.isEmpty((String)mimeType)) continue;
            List languagesByMimeType = (List)ourRegisteredMimeTypes.get(mimeType);
            if (languagesByMimeType == null) {
                languagesByMimeType = (List)ConcurrencyUtil.cacheOrGet(ourRegisteredMimeTypes, (Object)mimeType, (Object)ContainerUtil.createConcurrentList());
            }
            languagesByMimeType.add(this);
        }
        if (baseLanguage != null) {
            baseLanguage.myDialects.add(this);
        }
    }

    @NotNull
    public static Collection<Language> getRegisteredLanguages() {
        Collection<Language> languages = ourRegisteredLanguages.values();
        return Collections.unmodifiableCollection(new ArrayList<Language>(languages));
    }

    public static <T extends Language> T findInstance(@NotNull Class<T> klass) {
        Language t = ourRegisteredLanguages.get(klass);
        return (T)((Object)t);
    }

    @NotNull
    public static Collection<Language> findInstancesByMimeType(@Nullable String mimeType) {
        List result = mimeType == null ? null : (List)ourRegisteredMimeTypes.get(mimeType);
        return result == null ? Collections.emptyList() : Collections.unmodifiableCollection(result);
    }

    public String toString() {
        return "Language: " + this.myID;
    }

    @NotNull
    public String[] getMimeTypes() {
        return this.myMimeTypes;
    }

    @NotNull
    public String getID() {
        return this.myID;
    }

    @Nullable
    public LanguageFileType getAssociatedFileType() {
        FileType[] types;
        for (FileType fileType : types = FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
            if (!(fileType instanceof LanguageFileType) || ((LanguageFileType)fileType).getLanguage() != this) continue;
            return (LanguageFileType)fileType;
        }
        for (FileType fileType : types) {
            if (!(fileType instanceof LanguageFileType) || !this.isKindOf(((LanguageFileType)fileType).getLanguage())) continue;
            return (LanguageFileType)fileType;
        }
        return null;
    }

    @Nullable
    public Language getBaseLanguage() {
        return this.myBaseLanguage;
    }

    @NotNull
    public String getDisplayName() {
        return this.getID();
    }

    public final boolean is(Language another) {
        return this == another;
    }

    public boolean isCaseSensitive() {
        return this.myBaseLanguage != null && this.myBaseLanguage.isCaseSensitive();
    }

    public final boolean isKindOf(Language another) {
        for (Language l = this; l != null; l = l.getBaseLanguage()) {
            if (!l.is(another)) continue;
            return true;
        }
        return false;
    }

    public final boolean isKindOf(@NotNull String anotherLanguageId) {
        for (Language l = this; l != null; l = l.getBaseLanguage()) {
            if (!l.getID().equals(anotherLanguageId)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<Language> getDialects() {
        return this.myDialects;
    }

    @Nullable
    public static Language findLanguageByID(String id) {
        return id == null ? null : ourRegisteredIDs.get(id);
    }

    protected Language(@NotNull String ID, boolean register) {
        this.myID = ID;
        this.myBaseLanguage = null;
        this.myMimeTypes = null;
    }
}

