/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.lang.MetaLanguage;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageExtension<T>
extends KeyedExtensionCollector<T, Language> {
    private final T myDefaultImplementation;
    private final Key<T> IN_LANGUAGE_CACHE;

    public LanguageExtension(@NonNls String epName) {
        this(epName, null);
    }

    public LanguageExtension(@NonNls String epName, @Nullable T defaultImplementation) {
        super(epName);
        this.myDefaultImplementation = defaultImplementation;
        this.IN_LANGUAGE_CACHE = Key.create((String)("EXTENSIONS_IN_LANGUAGE_" + epName));
    }

    @Override
    @NotNull
    protected String keyToString(@NotNull Language key) {
        return key.getID();
    }

    public T forLanguage(@NotNull Language l) {
        Object cached = l.getUserData(this.IN_LANGUAGE_CACHE);
        if (cached != null) {
            return (T)cached;
        }
        Object result = this.findForLanguage(l);
        if (result == null) {
            return null;
        }
        result = l.putUserDataIfAbsent(this.IN_LANGUAGE_CACHE, result);
        return result;
    }

    protected T findForLanguage(@NotNull Language l) {
        T result;
        MetaLanguage metaLanguage;
        List extensions = this.forKey(l);
        if (!extensions.isEmpty()) {
            return extensions.get(0);
        }
        Language base = l.getBaseLanguage();
        if (base != null) {
            return this.forLanguage(base);
        }
        MetaLanguage[] metaLanguageArray = MetaLanguage.all();
        int n = metaLanguageArray.length;
        for (int j = 0; !(j >= n || (metaLanguage = metaLanguageArray[j]).matchesLanguage(l) && (result = this.forLanguage(metaLanguage)) != null); ++j) {
        }
        return this.myDefaultImplementation;
    }

    @NotNull
    public List<T> allForLanguage(@NotNull Language language) {
        boolean copyList = true;
        ArrayList result = null;
        for (Language l = language; l != null; l = l.getBaseLanguage()) {
            ArrayList list = this.forKey(l);
            if (result == null) {
                result = list;
                continue;
            }
            if (list.isEmpty()) continue;
            if (copyList) {
                result = ContainerUtil.newArrayList((Iterable)ContainerUtil.concat(result, list));
                copyList = false;
                continue;
            }
            result.addAll(list);
        }
        return result;
    }

    @NotNull
    public List<T> allForLanguageOrAny(@NotNull Language l) {
        ArrayList<T> providers = new ArrayList<T>(this.allForLanguage(l));
        if (l != Language.ANY) {
            providers.addAll(this.allForLanguage(Language.ANY));
        }
        if (!(l instanceof MetaLanguage)) {
            for (MetaLanguage metaLanguage : MetaLanguage.all()) {
                providers.addAll(this.allForLanguage(metaLanguage));
            }
        }
        return providers;
    }

    protected T getDefaultImplementation() {
        return this.myDefaultImplementation;
    }

    @NotNull
    protected Key<T> getLanguageCache() {
        return this.IN_LANGUAGE_CACHE;
    }

    @NotNull
    protected Set<String> getAllBaseLanguageIdsWithAny(@NotNull Language key) {
        THashSet allowed = new THashSet();
        while (key != null) {
            allowed.add(this.keyToString(key));
            key = key.getBaseLanguage();
        }
        allowed.add("any");
        for (MetaLanguage metaLanguage : MetaLanguage.all()) {
            allowed.add(metaLanguage.getID());
        }
        return allowed;
    }
}

