/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiBuilderUtil {
    private PsiBuilderUtil() {
    }

    public static void advance(PsiBuilder builder, int count) {
        for (int i2 = 0; i2 < count && !builder.eof(); ++i2) {
            builder.getTokenType();
            builder.advanceLexer();
        }
    }

    public static boolean expect(PsiBuilder builder, IElementType expectedType) {
        if (builder.getTokenType() == expectedType) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean expect(PsiBuilder builder, TokenSet expectedTypes) {
        if (expectedTypes.contains(builder.getTokenType())) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    public static void drop(PsiBuilder.Marker ... markers) {
        for (PsiBuilder.Marker marker : markers) {
            if (marker == null) continue;
            marker.drop();
        }
    }

    public static void rollbackTo(@Nullable PsiBuilder.Marker marker) {
        if (marker != null) {
            marker.rollbackTo();
        }
    }

    @NotNull
    public static CharSequence rawTokenText(PsiBuilder builder, int index) {
        return builder.getOriginalText().subSequence(builder.rawTokenTypeStart(index), builder.rawTokenTypeStart(index + 1));
    }
}

