/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.cacheBuilder;

import com.intellij.lang.cacheBuilder.VersionedWordsScanner;
import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.lexer.Lexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class DefaultWordsScanner
extends VersionedWordsScanner {
    private final Lexer myLexer;
    private final TokenSet myIdentifierTokenSet;
    private final TokenSet myCommentTokenSet;
    private final TokenSet myLiteralTokenSet;
    private final TokenSet mySkipCodeContextTokenSet;
    private final TokenSet myProcessAsWordTokenSet;
    private boolean myMayHaveFileRefsInLiterals;

    public DefaultWordsScanner(Lexer lexer, TokenSet identifierTokenSet, TokenSet commentTokenSet, TokenSet literalTokenSet) {
        this(lexer, identifierTokenSet, commentTokenSet, literalTokenSet, TokenSet.EMPTY);
    }

    public DefaultWordsScanner(Lexer lexer, TokenSet identifierTokenSet, TokenSet commentTokenSet, TokenSet literalTokenSet, @NotNull TokenSet skipCodeContextTokenSet) {
        this(lexer, identifierTokenSet, commentTokenSet, literalTokenSet, skipCodeContextTokenSet, TokenSet.EMPTY);
    }

    public DefaultWordsScanner(Lexer lexer, TokenSet identifierTokenSet, TokenSet commentTokenSet, TokenSet literalTokenSet, @NotNull TokenSet skipCodeContextTokenSet, @NotNull TokenSet processAsWordTokenSet) {
        this.myLexer = lexer;
        this.myIdentifierTokenSet = identifierTokenSet;
        this.myCommentTokenSet = commentTokenSet;
        this.myLiteralTokenSet = literalTokenSet;
        this.mySkipCodeContextTokenSet = skipCodeContextTokenSet;
        this.myProcessAsWordTokenSet = processAsWordTokenSet;
    }

    @Override
    public void processWords(CharSequence fileText, Processor<WordOccurrence> processor) {
        IElementType type;
        this.myLexer.start(fileText);
        WordOccurrence occurrence = new WordOccurrence(fileText, 0, 0, null);
        while ((type = this.myLexer.getTokenType()) != null) {
            if (this.myProcessAsWordTokenSet.contains(type)) {
                occurrence.init(fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.CODE);
                processor.process((Object)occurrence);
            } else if (this.myIdentifierTokenSet.contains(type) ? !DefaultWordsScanner.stripWords(processor, fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.CODE, occurrence, false) : (this.myCommentTokenSet.contains(type) ? !DefaultWordsScanner.stripWords(processor, fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.COMMENTS, occurrence, false) : (this.myLiteralTokenSet.contains(type) ? !DefaultWordsScanner.stripWords(processor, fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.LITERALS, occurrence, this.myMayHaveFileRefsInLiterals) : !this.mySkipCodeContextTokenSet.contains(type) && !DefaultWordsScanner.stripWords(processor, fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.CODE, occurrence, false)))) {
                return;
            }
            this.myLexer.advance();
        }
    }

    protected static boolean stripWords(Processor<WordOccurrence> processor, CharSequence tokenText, int from, int to, WordOccurrence.Kind kind, @NotNull WordOccurrence occurrence, boolean mayHaveFileRefs) {
        int index = from;
        while (index != to) {
            char c;
            char c2 = tokenText.charAt(index);
            if (!DefaultWordsScanner.isAsciiIdentifierPart(c2) && !Character.isJavaIdentifierStart(c2)) {
                ++index;
                continue;
            }
            int wordStart = index;
            while (++index != to && (DefaultWordsScanner.isAsciiIdentifierPart(c = tokenText.charAt(index)) || Character.isJavaIdentifierPart(c))) {
            }
            int wordEnd = index;
            occurrence.init(tokenText, wordStart, wordEnd, kind);
            if (!processor.process((Object)occurrence)) {
                return false;
            }
            if (!mayHaveFileRefs) continue;
            occurrence.init(tokenText, wordStart, wordEnd, WordOccurrence.Kind.FOREIGN_LANGUAGE);
            if (processor.process((Object)occurrence)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAsciiIdentifierPart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '$';
    }

    public void setMayHaveFileRefsInLiterals(boolean mayHaveFileRefsInLiterals) {
        this.myMayHaveFileRefsInLiterals = mayHaveFileRefsInLiterals;
    }
}

