/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CompositeFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomFoldingBuilder
extends FoldingBuilderEx
implements PossiblyDumbAware {
    private CustomFoldingProvider myDefaultProvider;
    private static final RegistryValue myMaxLookupDepth = Registry.get((String)"custom.folding.max.lookup.depth");
    private static final ThreadLocal<Set<ASTNode>> ourCustomRegionElements = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public final FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        ourCustomRegionElements.set((Set<ASTNode>)new HashSet());
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        try {
            if (CustomFoldingProvider.getAllProviders().length > 0) {
                this.myDefaultProvider = null;
                ASTNode rootNode = root.getNode();
                if (rootNode != null) {
                    this.addCustomFoldingRegionsRecursively(new FoldingStack(rootNode), rootNode, descriptors, 0);
                }
            }
            this.buildLanguageFoldRegions(descriptors, root, document, quick);
        }
        finally {
            ourCustomRegionElements.set(null);
        }
        return descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
    }

    @Override
    @NotNull
    public final FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        return this.buildFoldRegions(node.getPsi(), document, false);
    }

    protected abstract void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> var1, @NotNull PsiElement var2, @NotNull Document var3, boolean var4);

    private void addCustomFoldingRegionsRecursively(@NotNull FoldingStack foldingStack, @NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors, int currDepth) {
        FoldingStack localFoldingStack = this.isCustomFoldingRoot(node) ? new FoldingStack(node) : foldingStack;
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (this.isCustomRegionStart(child)) {
                localFoldingStack.push(child);
                continue;
            }
            if (this.isCustomRegionEnd(child)) {
                if (localFoldingStack.isEmpty()) continue;
                ASTNode startNode = (ASTNode)localFoldingStack.pop();
                int startOffset = startNode.getTextRange().getStartOffset();
                TextRange range = new TextRange(startOffset, child.getTextRange().getEndOffset());
                startNode.getPsi().putUserData(CompositeFoldingBuilder.FOLDING_BUILDER, this);
                descriptors.add(new FoldingDescriptor(startNode, range));
                Set<ASTNode> nodeSet = ourCustomRegionElements.get();
                nodeSet.add(startNode);
                nodeSet.add(child);
                continue;
            }
            if (currDepth >= myMaxLookupDepth.asInteger()) continue;
            this.addCustomFoldingRegionsRecursively(localFoldingStack, child, descriptors, currDepth + 1);
        }
    }

    @Override
    public final String getPlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        String elementText;
        CustomFoldingProvider defaultProvider;
        if (this.isCustomFoldingCandidate(node) && (defaultProvider = this.getDefaultProvider(elementText = node.getText())) != null && defaultProvider.isCustomRegionStart(elementText)) {
            return defaultProvider.getPlaceholderText(elementText);
        }
        return this.getLanguagePlaceholderText(node, range);
    }

    protected abstract String getLanguagePlaceholderText(@NotNull ASTNode var1, @NotNull TextRange var2);

    @Override
    public final String getPlaceholderText(@NotNull ASTNode node) {
        return "...";
    }

    @Override
    public final boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (this.isCustomRegionStart(node)) {
            String childText = node.getText();
            CustomFoldingProvider defaultProvider = this.getDefaultProvider(childText);
            return defaultProvider != null && defaultProvider.isCollapsedByDefault(childText);
        }
        return this.isRegionCollapsedByDefault(node);
    }

    protected abstract boolean isRegionCollapsedByDefault(@NotNull ASTNode var1);

    public final boolean isCustomRegionStart(@NotNull ASTNode node) {
        if (this.isCustomFoldingCandidate(node)) {
            String nodeText = node.getText();
            CustomFoldingProvider defaultProvider = this.getDefaultProvider(nodeText);
            return defaultProvider != null && defaultProvider.isCustomRegionStart(nodeText);
        }
        return false;
    }

    protected final boolean isCustomRegionEnd(@NotNull ASTNode node) {
        if (this.isCustomFoldingCandidate(node)) {
            String nodeText = node.getText();
            CustomFoldingProvider defaultProvider = this.getDefaultProvider(nodeText);
            return defaultProvider != null && defaultProvider.isCustomRegionEnd(nodeText);
        }
        return false;
    }

    protected static boolean isCustomRegionElement(PsiElement element) {
        Set<ASTNode> set = ourCustomRegionElements.get();
        return set != null && element != null && set.contains(element.getNode());
    }

    @Nullable
    private CustomFoldingProvider getDefaultProvider(String elementText) {
        if (this.myDefaultProvider == null) {
            for (CustomFoldingProvider provider : CustomFoldingProvider.getAllProviders()) {
                if (!provider.isCustomRegionStart(elementText) && !provider.isCustomRegionEnd(elementText)) continue;
                this.myDefaultProvider = provider;
            }
        }
        return this.myDefaultProvider;
    }

    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        return node.getPsi() instanceof PsiComment;
    }

    public final boolean isCustomFoldingCandidate(@NotNull PsiElement element) {
        ASTNode node = element.getNode();
        return node != null && this.isCustomFoldingCandidate(node);
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        return node.getFirstChildNode() != null;
    }

    @Override
    public boolean isDumbAware() {
        return true;
    }

    private static class FoldingStack
    extends Stack<ASTNode> {
        @NotNull
        private final ASTNode owner;

        private FoldingStack(@NotNull ASTNode owner) {
            super(1);
            this.owner = owner;
        }

        @NotNull
        public ASTNode getOwner() {
            return this.owner;
        }
    }
}

