/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public abstract class CompositeLexer
extends LexerBase {
    private final Lexer myLexer1;
    private final Lexer myLexer2;
    private int myCurOffset;

    public CompositeLexer(Lexer lexer1, Lexer lexer2) {
        this.myLexer1 = lexer1;
        this.myLexer2 = lexer2;
    }

    protected abstract IElementType getCompositeTokenType(IElementType var1, IElementType var2);

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myLexer1.start(buffer, startOffset, endOffset, initialState >> 16 & 0xFFFF);
        this.myLexer2.start(buffer, startOffset, endOffset, initialState & 0xFFFF);
        this.myCurOffset = startOffset;
    }

    @Override
    @NotNull
    public CharSequence getBufferSequence() {
        return this.myLexer1.getBufferSequence();
    }

    @Override
    public int getState() {
        int state = this.myLexer1.getState();
        int state2 = this.myLexer2.getState();
        if (state >= 0 && state < Short.MAX_VALUE && state2 >= 0 && state2 < Short.MAX_VALUE) {
            return (state << 16) + state2;
        }
        return 0;
    }

    @Override
    public IElementType getTokenType() {
        IElementType type1 = this.myLexer1.getTokenType();
        if (type1 == null) {
            return null;
        }
        IElementType type2 = this.myLexer2.getTokenType();
        return this.getCompositeTokenType(type1, type2);
    }

    @Override
    public int getTokenStart() {
        return this.myCurOffset;
    }

    @Override
    public int getTokenEnd() {
        return Math.min(this.myLexer1.getTokenEnd(), this.myLexer2.getTokenEnd());
    }

    @Override
    public void advance() {
        int end1 = this.myLexer1.getTokenEnd();
        int end2 = this.myLexer2.getTokenEnd();
        this.myCurOffset = Math.min(end1, end2);
        if (this.myCurOffset == end1) {
            this.myLexer1.advance();
        }
        if (this.myCurOffset == end2) {
            this.myLexer2.advance();
        }
    }

    @Override
    public int getBufferEnd() {
        return this.myLexer1.getBufferEnd();
    }
}

