/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class StringLiteralLexer
extends LexerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lexer.StringLiteralLexer");
    private static final short AFTER_FIRST_QUOTE = 1;
    private static final short AFTER_LAST_QUOTE = 2;
    public static final char NO_QUOTE_CHAR = '\uffff';
    protected CharSequence myBuffer;
    protected int myStart;
    protected int myEnd;
    private int myState;
    private int myLastState;
    protected int myBufferEnd;
    protected final char myQuoteChar;
    private final IElementType myOriginalLiteralToken;
    private final boolean myCanEscapeEolOrFramingSpaces;
    private final String myAdditionalValidEscapes;
    private boolean mySeenEscapedSpacesOnly;
    private final boolean myAllowOctal;
    private final boolean myAllowHex;

    public StringLiteralLexer(char quoteChar, IElementType originalLiteralToken) {
        this(quoteChar, originalLiteralToken, false, null);
    }

    public StringLiteralLexer(char quoteChar, IElementType originalLiteralToken, boolean canEscapeEolOrFramingSpaces, String additionalValidEscapes) {
        this(quoteChar, originalLiteralToken, canEscapeEolOrFramingSpaces, additionalValidEscapes, true, false);
    }

    public StringLiteralLexer(char quoteChar, IElementType originalLiteralToken, boolean canEscapeEolOrFramingSpaces, String additionalValidEscapes, boolean allowOctal, boolean allowHex) {
        this.myQuoteChar = quoteChar;
        this.myOriginalLiteralToken = originalLiteralToken;
        this.myCanEscapeEolOrFramingSpaces = canEscapeEolOrFramingSpaces;
        this.myAdditionalValidEscapes = additionalValidEscapes;
        this.myAllowOctal = allowOctal;
        this.myAllowHex = allowHex;
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myBuffer = buffer;
        this.myStart = startOffset;
        this.myState = this.myQuoteChar == '\uffff' ? 1 : initialState;
        this.myLastState = initialState;
        this.myBufferEnd = endOffset;
        this.myEnd = this.locateToken(this.myStart);
        this.mySeenEscapedSpacesOnly = true;
    }

    @Override
    public int getState() {
        return this.myLastState;
    }

    @Override
    public IElementType getTokenType() {
        if (this.myStart >= this.myEnd) {
            return null;
        }
        if (this.myBuffer.charAt(this.myStart) != '\\') {
            this.mySeenEscapedSpacesOnly = false;
            return this.myOriginalLiteralToken;
        }
        if (this.myStart + 1 >= this.myEnd) {
            return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
        }
        char nextChar = this.myBuffer.charAt(this.myStart + 1);
        this.mySeenEscapedSpacesOnly &= nextChar == ' ';
        if (this.myCanEscapeEolOrFramingSpaces && (nextChar == '\n' || nextChar == ' ' && (this.mySeenEscapedSpacesOnly || this.isTrailingSpace(this.myStart + 2)))) {
            return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
        if (nextChar == 'u') {
            return this.getUnicodeEscapeSequenceType();
        }
        if (nextChar == 'x' && this.myAllowHex) {
            for (int i2 = this.myStart + 2; i2 < this.myStart + 4; ++i2) {
                if (i2 < this.myEnd && StringUtil.isHexDigit((char)this.myBuffer.charAt(i2))) continue;
                return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            }
            return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
        switch (nextChar) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                if (!this.myAllowOctal) {
                    return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
                }
            }
            case '\"': 
            case '\'': 
            case '\\': 
            case 'b': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': {
                return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            }
        }
        if (this.myAdditionalValidEscapes != null && this.myAdditionalValidEscapes.indexOf(nextChar) != -1) {
            return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
        return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
    }

    @NotNull
    protected IElementType getUnicodeEscapeSequenceType() {
        for (int i2 = this.myStart + 2; i2 < this.myStart + 6; ++i2) {
            if (i2 < this.myEnd && StringUtil.isHexDigit((char)this.myBuffer.charAt(i2))) continue;
            return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
        }
        return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
    }

    private boolean isTrailingSpace(int start) {
        for (int i2 = start; i2 < this.myBufferEnd; i2 += 2) {
            char c = this.myBuffer.charAt(i2);
            if (c != '\\') {
                return false;
            }
            if (i2 == this.myBufferEnd - 1) {
                return false;
            }
            if (this.myBuffer.charAt(i2 + 1) == ' ') continue;
            return false;
        }
        return true;
    }

    @Override
    public int getTokenStart() {
        return this.myStart;
    }

    @Override
    public int getTokenEnd() {
        return this.myEnd;
    }

    private int locateToken(int start) {
        if (start == this.myBufferEnd) {
            this.myState = 2;
        }
        if (this.myState == 2) {
            return start;
        }
        int i2 = start;
        if (this.myBuffer.charAt(i2) == '\\') {
            LOG.assertTrue(this.myState == 1);
            if (++i2 == this.myBufferEnd || this.myBuffer.charAt(i2) == '\n' && !this.myCanEscapeEolOrFramingSpaces) {
                this.myState = 2;
                return i2;
            }
            if (this.myAllowOctal && this.myBuffer.charAt(i2) >= '0' && this.myBuffer.charAt(i2) <= '7') {
                char first = this.myBuffer.charAt(i2);
                if (++i2 < this.myBufferEnd && this.myBuffer.charAt(i2) >= '0' && this.myBuffer.charAt(i2) <= '7' && ++i2 < this.myBufferEnd && first <= '3' && this.myBuffer.charAt(i2) >= '0' && this.myBuffer.charAt(i2) <= '7') {
                    ++i2;
                }
                return i2;
            }
            if (this.myAllowHex && this.myBuffer.charAt(i2) == 'x') {
                ++i2;
                while (i2 < start + 4) {
                    if (i2 == this.myBufferEnd || this.myBuffer.charAt(i2) == '\n' || this.myBuffer.charAt(i2) == this.myQuoteChar) {
                        return i2;
                    }
                    ++i2;
                }
                return i2;
            }
            if (this.myBuffer.charAt(i2) == 'u') {
                return this.locateUnicodeEscapeSequence(start, i2);
            }
            return i2 + 1;
        }
        LOG.assertTrue(this.myState == 1 || this.myBuffer.charAt(i2) == this.myQuoteChar, (Object)this);
        while (i2 < this.myBufferEnd) {
            if (this.myBuffer.charAt(i2) == '\\') {
                return i2;
            }
            if (this.myState == 1 && this.myBuffer.charAt(i2) == this.myQuoteChar) {
                if (i2 + 1 == this.myBufferEnd) {
                    this.myState = 2;
                }
                return i2 + 1;
            }
            ++i2;
            this.myState = 1;
        }
        return i2;
    }

    protected int locateUnicodeEscapeSequence(int start, int i2) {
        ++i2;
        while (i2 < start + 6) {
            if (i2 == this.myBufferEnd || this.myBuffer.charAt(i2) == '\n' || this.myBuffer.charAt(i2) == this.myQuoteChar) {
                return i2;
            }
            ++i2;
        }
        return i2;
    }

    @Override
    public void advance() {
        this.myLastState = this.myState;
        this.myStart = this.myEnd;
        this.myEnd = this.locateToken(this.myStart);
    }

    @Override
    @NotNull
    public CharSequence getBufferSequence() {
        return this.myBuffer;
    }

    @Override
    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    public String toString() {
        return "StringLiteralLexer {myAllowHex=" + this.myAllowHex + ", myAllowOctal=" + this.myAllowOctal + ", mySeenEscapedSpacesOnly=" + this.mySeenEscapedSpacesOnly + ", myAdditionalValidEscapes='" + this.myAdditionalValidEscapes + '\'' + ", myCanEscapeEolOrFramingSpaces=" + this.myCanEscapeEolOrFramingSpaces + ", myOriginalLiteralToken=" + this.myOriginalLiteralToken + ", myQuoteChar=" + this.myQuoteChar + ", myBufferEnd=" + this.myBufferEnd + ", myLastState=" + this.myLastState + ", myState=" + this.myState + ", myEnd=" + this.myEnd + ", myStart=" + this.myStart + ", myToken=" + (this.myBuffer == null || this.myEnd < this.myStart || this.myEnd > this.myBuffer.length() ? null : this.myBuffer.subSequence(this.myStart, this.myEnd)) + '}';
    }
}

