/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEventVisitor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataContextWrapper;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PlaceProvider;
import java.awt.event.InputEvent;
import java.util.HashMap;
import java.util.Map;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnActionEvent
implements PlaceProvider<String> {
    private final InputEvent myInputEvent;
    @NotNull
    private final ActionManager myActionManager;
    @NotNull
    private final DataContext myDataContext;
    @NotNull
    private final String myPlace;
    @NotNull
    private final Presentation myPresentation;
    @JdkConstants.InputEventMask
    private final int myModifiers;
    private boolean myWorksInInjected;
    @NonNls
    private static final String ourInjectedPrefix = "$injected$.";
    private static final Map<String, String> ourInjectedIds = new HashMap<String, String>();

    public AnActionEvent(InputEvent inputEvent, @NotNull DataContext dataContext, @NotNull @NonNls String place, @NotNull Presentation presentation, @NotNull ActionManager actionManager, @JdkConstants.InputEventMask int modifiers) {
        this.myInputEvent = inputEvent;
        this.myActionManager = actionManager;
        this.myDataContext = dataContext;
        this.myPlace = place;
        this.myPresentation = presentation;
        this.myModifiers = modifiers;
    }

    @Deprecated
    @NotNull
    public static AnActionEvent createFromInputEvent(@NotNull AnAction action, @Nullable InputEvent event, @NotNull String place) {
        DataContext context = event == null ? DataManager.getInstance().getDataContext() : DataManager.getInstance().getDataContext(event.getComponent());
        return AnActionEvent.createFromAnAction(action, event, place, context);
    }

    @NotNull
    public static AnActionEvent createFromAnAction(@NotNull AnAction action, @Nullable InputEvent event, @NotNull String place, @NotNull DataContext dataContext) {
        int modifiers = event == null ? 0 : event.getModifiers();
        Presentation presentation = action.getTemplatePresentation().clone();
        AnActionEvent anActionEvent = new AnActionEvent(event, dataContext, place, presentation, ActionManager.getInstance(), modifiers);
        anActionEvent.setInjectedContext(action.isInInjectedContext());
        return anActionEvent;
    }

    @NotNull
    public static AnActionEvent createFromDataContext(@NotNull String place, @Nullable Presentation presentation, @NotNull DataContext dataContext) {
        return new AnActionEvent(null, dataContext, place, presentation == null ? new Presentation() : presentation, ActionManager.getInstance(), 0);
    }

    @NotNull
    public static AnActionEvent createFromInputEvent(@Nullable InputEvent event, @NotNull String place, @NotNull Presentation presentation, @NotNull DataContext dataContext) {
        return new AnActionEvent(event, dataContext, place, presentation, ActionManager.getInstance(), event == null ? 0 : event.getModifiers());
    }

    public InputEvent getInputEvent() {
        return this.myInputEvent;
    }

    @Nullable
    public Project getProject() {
        return this.getData(CommonDataKeys.PROJECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNls
    public static String injectedId(String dataId) {
        Map<String, String> map = ourInjectedIds;
        synchronized (map) {
            String injected = ourInjectedIds.get(dataId);
            if (injected == null) {
                injected = ourInjectedPrefix + dataId;
                ourInjectedIds.put(dataId, injected);
            }
            return injected;
        }
    }

    @NonNls
    public static String uninjectedId(@NotNull String dataId) {
        return StringUtil.trimStart((String)dataId, (String)ourInjectedPrefix);
    }

    public static DataContext getInjectedDataContext(DataContext context) {
        return new DataContextWrapper(context){

            @Override
            @Nullable
            public Object getData(@NonNls String dataId) {
                Object injected = super.getData(AnActionEvent.injectedId(dataId));
                if (injected != null) {
                    return injected;
                }
                return super.getData(dataId);
            }
        };
    }

    @NotNull
    public DataContext getDataContext() {
        return this.myWorksInInjected ? AnActionEvent.getInjectedDataContext(this.myDataContext) : this.myDataContext;
    }

    @Nullable
    public <T> T getData(@NotNull DataKey<T> key) {
        return this.getDataContext().getData(key);
    }

    @NotNull
    public <T> T getRequiredData(@NotNull DataKey<T> key) {
        T data = this.getData(key);
        assert (data != null);
        return data;
    }

    @Override
    @NotNull
    public String getPlace() {
        return this.myPlace;
    }

    @NotNull
    public Presentation getPresentation() {
        return this.myPresentation;
    }

    @JdkConstants.InputEventMask
    public int getModifiers() {
        return this.myModifiers;
    }

    @NotNull
    public ActionManager getActionManager() {
        return this.myActionManager;
    }

    public void setInjectedContext(boolean worksInInjected) {
        this.myWorksInInjected = worksInInjected;
    }

    public boolean isInInjectedContext() {
        return this.myWorksInInjected;
    }

    public void accept(@NotNull AnActionEventVisitor visitor) {
        visitor.visitEvent(this);
    }
}

