/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.ExecutorService;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class AsyncUpdateAction<T>
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.AsyncUpdateAction");
    private static final ExecutorService ourUpdaterService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"AsyncUpdateAction pool", (int)1);

    @Override
    public final void update(AnActionEvent e) {
        T data = this.prepareDataFromContext(e);
        Presentation originalPresentation = e.getPresentation();
        if (!this.forceSyncUpdate(e) && this.isDumbAware()) {
            Presentation realPresentation = originalPresentation.clone();
            ourUpdaterService.submit(() -> {
                this.performUpdate(realPresentation, data);
                SwingUtilities.invokeLater(() -> {
                    if (originalPresentation.isVisible() != realPresentation.isVisible()) {
                        LOG.error("Async update is not supported for actions that change their visibility.Either stop extending AsyncUpdateAction or override forceSyncUpdate() to return true.Action class is: " + this.getClass().getName());
                    }
                    originalPresentation.copyFrom(realPresentation);
                });
            });
            originalPresentation.setVisible(true);
            originalPresentation.setEnabled(false);
        } else {
            this.performUpdate(originalPresentation, data);
        }
    }

    @Override
    public final void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        this.performUpdate(e.getPresentation(), this.prepareDataFromContext(e));
    }

    protected abstract T prepareDataFromContext(AnActionEvent var1);

    protected abstract void performUpdate(Presentation var1, T var2);

    protected boolean forceSyncUpdate(AnActionEvent e) {
        return false;
    }
}

