/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionInGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultActionGroup
extends ActionGroup {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.DefaultActionGroup");
    private final List<AnAction> mySortedChildren = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<Pair<AnAction, Constraints>> myPairs = ContainerUtil.createLockFreeCopyOnWriteList();

    public DefaultActionGroup() {
        this(null, false);
    }

    public DefaultActionGroup(AnAction ... actions) {
        this(Arrays.asList(actions));
    }

    public DefaultActionGroup(@NotNull List<? extends AnAction> actions) {
        this(null, false);
        this.addActions(actions);
    }

    public DefaultActionGroup(@NotNull String name, @NotNull List<? extends AnAction> actions) {
        this(name, false);
        this.addActions(actions);
    }

    private void addActions(@NotNull List<? extends AnAction> actions) {
        for (AnAction anAction : actions) {
            this.add(anAction);
        }
    }

    public DefaultActionGroup(String shortName, boolean popup) {
        super(shortName, popup);
    }

    public final void add(@NotNull AnAction action, @NotNull ActionManager actionManager) {
        this.add(action, Constraints.LAST, actionManager);
    }

    public final void add(@NotNull AnAction action) {
        this.addAction(action, Constraints.LAST);
    }

    public final ActionInGroup addAction(@NotNull AnAction action) {
        return this.addAction(action, Constraints.LAST);
    }

    public final void addSeparator() {
        this.add(Separator.getInstance());
    }

    public final void add(@NotNull AnAction action, @NotNull Constraints constraint) {
        this.add(action, constraint, ActionManager.getInstance());
    }

    public final ActionInGroup addAction(@NotNull AnAction action, @NotNull Constraints constraint) {
        return this.addAction(action, constraint, ActionManager.getInstance());
    }

    public final void add(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        this.addAction(action, constraint, actionManager);
    }

    public final ActionInGroup addAction(@NotNull AnAction action, @NotNull Constraints constraint, @NotNull ActionManager actionManager) {
        if (action == this) {
            throw new IllegalArgumentException("Cannot add a group to itself");
        }
        if (!(action instanceof Separator)) {
            if (this.mySortedChildren.contains(action)) {
                throw new IllegalArgumentException("cannot add an action twice: " + action);
            }
            for (Pair<AnAction, Constraints> pair : this.myPairs) {
                if (!action.equals(pair.first)) continue;
                throw new IllegalArgumentException("cannot add an action twice: " + action);
            }
        }
        constraint = (Constraints)constraint.clone();
        if (constraint.myAnchor == Anchor.FIRST) {
            this.mySortedChildren.add(0, action);
        } else if (constraint.myAnchor == Anchor.LAST) {
            this.mySortedChildren.add(action);
        } else if (this.addToSortedList(action, constraint, actionManager)) {
            this.actionAdded(action, actionManager);
        } else {
            this.myPairs.add((Pair<AnAction, Constraints>)Pair.create((Object)action, (Object)constraint));
        }
        return new ActionInGroup(this, action);
    }

    private void actionAdded(AnAction addedAction, ActionManager actionManager) {
        String addedActionId;
        String string = addedActionId = addedAction instanceof ActionStub ? ((ActionStub)addedAction).getId() : actionManager.getId(addedAction);
        if (addedActionId == null) {
            return;
        }
        block0: while (!this.myPairs.isEmpty()) {
            for (int i2 = 0; i2 < this.myPairs.size(); ++i2) {
                Pair<AnAction, Constraints> pair = this.myPairs.get(i2);
                if (!this.addToSortedList((AnAction)pair.first, (Constraints)pair.second, actionManager)) continue;
                this.myPairs.remove(i2);
                continue block0;
            }
        }
    }

    private boolean addToSortedList(@NotNull AnAction action, Constraints constraint, ActionManager actionManager) {
        int index = DefaultActionGroup.findIndex(constraint.myRelativeToActionId, this.mySortedChildren, actionManager);
        if (index == -1) {
            return false;
        }
        if (constraint.myAnchor == Anchor.BEFORE) {
            this.mySortedChildren.add(index, action);
        } else {
            this.mySortedChildren.add(index + 1, action);
        }
        return true;
    }

    private static int findIndex(String actionId, List<? extends AnAction> actions, ActionManager actionManager) {
        for (int i2 = 0; i2 < actions.size(); ++i2) {
            String id;
            AnAction action = actions.get(i2);
            if (!(action instanceof ActionStub ? ((ActionStub)action).getId().equals(actionId) : (id = actionManager.getId(action)) != null && id.equals(actionId))) continue;
            return i2;
        }
        return -1;
    }

    public final void remove(AnAction action) {
        if (!this.mySortedChildren.remove(action)) {
            for (int i2 = 0; i2 < this.myPairs.size(); ++i2) {
                Pair<AnAction, Constraints> pair = this.myPairs.get(i2);
                if (!((AnAction)pair.first).equals(action)) continue;
                this.myPairs.remove(i2);
                break;
            }
        }
    }

    public final void removeAll() {
        this.mySortedChildren.clear();
        this.myPairs.clear();
    }

    public boolean replaceAction(@NotNull AnAction oldAction, @NotNull AnAction newAction) {
        int index = this.mySortedChildren.indexOf(oldAction);
        if (index >= 0) {
            this.mySortedChildren.set(index, newAction);
            return true;
        }
        for (int i2 = 0; i2 < this.myPairs.size(); ++i2) {
            Pair<AnAction, Constraints> pair = this.myPairs.get(i2);
            if (!((AnAction)pair.first).equals(newAction)) continue;
            this.myPairs.set(i2, (Pair<AnAction, Constraints>)Pair.create((Object)newAction, (Object)pair.second));
            return true;
        }
        return false;
    }

    public void copyFromGroup(@NotNull DefaultActionGroup other) {
        this.copyFrom(other);
        this.setPopup(other.isPopup());
        this.mySortedChildren.clear();
        this.mySortedChildren.addAll(other.mySortedChildren);
        this.myPairs.clear();
        this.myPairs.addAll(other.myPairs);
    }

    @Override
    @NotNull
    public final AnAction[] getChildren(@Nullable AnActionEvent e) {
        int i2;
        boolean hasNulls = false;
        int sortedSize = this.mySortedChildren.size();
        Object[] children = new AnAction[sortedSize + this.myPairs.size()];
        for (i2 = 0; i2 < sortedSize; ++i2) {
            AnAction action = this.mySortedChildren.get(i2);
            if (action == null) {
                LOG.error("Empty sorted child: " + this + ", " + this.getClass() + "; index=" + i2);
            }
            if (action instanceof ActionStub) {
                if ((action = this.unStub(e, (ActionStub)action)) == null) {
                    LOG.error("Can't unstub " + this.mySortedChildren.get(i2));
                } else {
                    this.mySortedChildren.set(i2, action);
                }
            }
            hasNulls |= action == null;
            children[i2] = action;
        }
        for (i2 = 0; i2 < this.myPairs.size(); ++i2) {
            Pair<AnAction, Constraints> pair = this.myPairs.get(i2);
            AnAction action = (AnAction)pair.first;
            if (action == null) {
                LOG.error("Empty pair child: " + this + ", " + this.getClass() + "; index=" + i2);
            } else if (action instanceof ActionStub) {
                if ((action = this.unStub(e, (ActionStub)action)) == null) {
                    LOG.error("Can't unstub " + pair);
                } else {
                    this.myPairs.set(i2, (Pair<AnAction, Constraints>)Pair.create((Object)action, (Object)pair.second));
                }
            }
            hasNulls |= action == null;
            children[i2 + sortedSize] = action;
        }
        if (hasNulls) {
            return (AnAction[])ContainerUtil.mapNotNull((Object[])children, (Function)FunctionUtil.id(), (Object[])AnAction.EMPTY_ARRAY);
        }
        return children;
    }

    @Nullable
    private AnAction unStub(@Nullable AnActionEvent e, ActionStub stub) {
        ActionManager actionManager = e != null ? e.getActionManager() : ActionManager.getInstance();
        try {
            AnAction action = actionManager.getAction(stub.getId());
            if (action == null) {
                LOG.error("Null child action in group " + this + " of class " + this.getClass() + ", id=" + stub.getId());
                return null;
            }
            this.replace(stub, action);
            return action;
        }
        catch (Throwable e1) {
            LOG.error(e1);
            return null;
        }
    }

    public final int getChildrenCount() {
        return this.mySortedChildren.size() + this.myPairs.size();
    }

    @NotNull
    public final AnAction[] getChildActionsOrStubs() {
        int i2;
        int sortedSize = this.mySortedChildren.size();
        AnAction[] children = new AnAction[sortedSize + this.myPairs.size()];
        for (i2 = 0; i2 < sortedSize; ++i2) {
            children[i2] = this.mySortedChildren.get(i2);
        }
        for (i2 = 0; i2 < this.myPairs.size(); ++i2) {
            children[i2 + sortedSize] = (AnAction)this.myPairs.get((int)i2).first;
        }
        return children;
    }

    public final void addAll(ActionGroup group) {
        for (AnAction each : group.getChildren(null)) {
            this.add(each);
        }
    }

    public final void addAll(Collection<? extends AnAction> actionList) {
        for (AnAction anAction : actionList) {
            this.add(anAction);
        }
    }

    public final void addAll(AnAction ... actions) {
        for (AnAction each : actions) {
            this.add(each);
        }
    }

    public void addSeparator(@Nullable String separatorText) {
        this.add(new Separator(separatorText));
    }
}

