/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EmptyAction
extends AnAction {
    private boolean myEnabled;

    public EmptyAction() {
    }

    public EmptyAction(boolean enabled) {
        this.myEnabled = enabled;
    }

    public EmptyAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    public static AnAction createEmptyAction(@Nullable String name, @Nullable Icon icon, boolean alwaysEnabled) {
        EmptyAction emptyAction = new EmptyAction(name, null, icon);
        emptyAction.myEnabled = alwaysEnabled;
        return emptyAction;
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
    }

    @Override
    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(this.myEnabled);
    }

    public static void setupAction(@NotNull AnAction action, @NotNull String id, @Nullable JComponent component) {
        ActionUtil.mergeFrom(action, id).registerCustomShortcutSet(component, null);
    }

    public static void registerActionShortcuts(@NotNull JComponent component, @NotNull JComponent fromComponent) {
        ActionUtil.copyRegisteredShortcuts(component, fromComponent);
    }

    @NotNull
    public static AnAction registerWithShortcutSet(@NotNull String id, @NotNull ShortcutSet shortcutSet, @NotNull JComponent component) {
        AnAction newAction = EmptyAction.wrap(ActionManager.getInstance().getAction(id));
        newAction.registerCustomShortcutSet(shortcutSet, component);
        return newAction;
    }

    public static AnAction wrap(AnAction action) {
        return action instanceof ActionGroup ? new MyDelegatingActionGroup((ActionGroup)action) : new MyDelegatingAction(action);
    }

    public static class MyDelegatingActionGroup
    extends ActionGroup {
        @NotNull
        private final ActionGroup myDelegate;

        public MyDelegatingActionGroup(@NotNull ActionGroup action) {
            this.myDelegate = action;
            this.copyFrom(action);
            this.setEnabledInModalContext(action.isEnabledInModalContext());
        }

        @NotNull
        public ActionGroup getDelegate() {
            return this.myDelegate;
        }

        @Override
        public boolean isPopup() {
            return this.myDelegate.isPopup();
        }

        @Override
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            return this.myDelegate.getChildren(e);
        }

        @Override
        public void update(AnActionEvent e) {
            this.myDelegate.update(e);
        }

        @Override
        public boolean canBePerformed(DataContext context) {
            return this.myDelegate.canBePerformed(context);
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            this.myDelegate.actionPerformed(e);
        }

        @Override
        public boolean isDumbAware() {
            return this.myDelegate.isDumbAware();
        }

        @Override
        public boolean isTransparentUpdate() {
            return this.myDelegate.isTransparentUpdate();
        }

        @Override
        public boolean isInInjectedContext() {
            return this.myDelegate.isInInjectedContext();
        }

        @Override
        public boolean hideIfNoVisibleChildren() {
            return this.myDelegate.hideIfNoVisibleChildren();
        }

        @Override
        public boolean disableIfNoVisibleChildren() {
            return this.myDelegate.disableIfNoVisibleChildren();
        }
    }

    public static class MyDelegatingAction
    extends AnAction {
        @NotNull
        private final AnAction myDelegate;

        public MyDelegatingAction(@NotNull AnAction action) {
            this.myDelegate = action;
            this.copyFrom(action);
            this.setEnabledInModalContext(action.isEnabledInModalContext());
        }

        @Override
        public void update(AnActionEvent e) {
            this.myDelegate.update(e);
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            this.myDelegate.actionPerformed(e);
        }

        @Override
        public boolean isDumbAware() {
            return this.myDelegate.isDumbAware();
        }

        @Override
        public boolean isTransparentUpdate() {
            return this.myDelegate.isTransparentUpdate();
        }

        @Override
        public boolean isInInjectedContext() {
            return this.myDelegate.isInInjectedContext();
        }
    }
}

