/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import org.jetbrains.annotations.NotNull;

public abstract class ReadAction<T>
extends BaseActionRunnable<T> {
    @Override
    @NotNull
    public RunResult<T> execute() {
        RunResult result = new RunResult(this);
        return (RunResult)ApplicationManager.getApplication().runReadAction(() -> result.run());
    }

    public static AccessToken start() {
        return ApplicationManager.getApplication().acquireReadActionLock();
    }

    public static <E extends Throwable> void run(@NotNull ThrowableRunnable<E> action) throws E {
        AccessToken token = ReadAction.start();
        try {
            action.run();
        }
        finally {
            token.finish();
        }
    }

    public static <T, E extends Throwable> T compute(@NotNull ThrowableComputable<T, E> action) throws E {
        AccessToken token = ReadAction.start();
        try {
            Object object = action.compute();
            return (T)object;
        }
        finally {
            token.finish();
        }
    }
}

