/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TransactionGuard {
    private static volatile TransactionGuard ourInstance;

    public static TransactionGuard getInstance() {
        TransactionGuard instance = ourInstance;
        if (instance == null) {
            ourInstance = instance = ServiceManager.getService(TransactionGuard.class);
        }
        return instance;
    }

    public static void submitTransaction(@NotNull Disposable parentDisposable, @NotNull Runnable transaction) {
        TransactionGuard guard = TransactionGuard.getInstance();
        guard.submitTransaction(parentDisposable, guard.getContextTransaction(), transaction);
    }

    public abstract void submitTransactionLater(@NotNull Disposable var1, @NotNull Runnable var2);

    public abstract void submitTransactionAndWait(@NotNull Runnable var1) throws ProcessCanceledException;

    public abstract void submitTransaction(@NotNull Disposable var1, @Nullable TransactionId var2, @NotNull Runnable var3);

    public abstract TransactionId getContextTransaction();
}

