/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableRunnable;
import org.jetbrains.annotations.NotNull;

public abstract class WriteAction<T>
extends BaseActionRunnable<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.WriteAction");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RunResult<T> execute() {
        RunResult result = new RunResult(this);
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            AccessToken token = WriteAction.start(this.getClass());
            try {
                result.run();
            }
            finally {
                token.finish();
            }
            return result;
        }
        if (application.isReadAccessAllowed()) {
            LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
        }
        TransactionGuard.getInstance().submitTransactionAndWait(() -> {
            AccessToken token = WriteAction.start(this.getClass());
            try {
                result.run();
            }
            finally {
                token.finish();
            }
        });
        if (!this.isSilentExecution()) {
            result.throwException();
        }
        return result;
    }

    @Deprecated
    @NotNull
    public static AccessToken start() {
        return WriteAction.start((Class)ObjectUtils.notNull((Object)ReflectionUtil.getGrandCallerClass(), WriteAction.class));
    }

    @Deprecated
    @NotNull
    public static AccessToken start(@NotNull Class clazz) {
        return ApplicationManager.getApplication().acquireWriteActionLock(clazz);
    }

    public static <E extends Throwable> void run(@NotNull ThrowableRunnable<E> action) throws E {
        AccessToken token = WriteAction.start();
        try {
            action.run();
        }
        finally {
            token.finish();
        }
    }

    public static <T, E extends Throwable> T compute(@NotNull ThrowableComputable<T, E> action) throws E {
        AccessToken token = WriteAction.start();
        try {
            Object object = action.compute();
            return (T)object;
        }
        finally {
            token.finish();
        }
    }
}

