/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class MainConfigurationStateSplitter
extends StateSplitterEx {
    @Override
    public final List<Pair<Element, String>> splitState(@NotNull Element state) {
        UniqueNameGenerator generator = new UniqueNameGenerator();
        SmartList result = new SmartList();
        Iterator iterator = state.getChildren(this.getSubStateTagName()).iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            iterator.remove();
            result.add(MainConfigurationStateSplitter.createItem(this.getSubStateFileName(element), generator, element));
        }
        if (!JDOMUtil.isEmpty((Element)state)) {
            result.add(MainConfigurationStateSplitter.createItem(this.getComponentStateFileName(), generator, state));
        }
        return result;
    }

    @Override
    public final void mergeStateInto(@NotNull Element target, @NotNull Element subState) {
        MainConfigurationStateSplitter.mergeStateInto(target, subState, this.getSubStateTagName());
    }

    @NotNull
    protected String getSubStateFileName(@NotNull Element element) {
        for (Element option : element.getChildren("option")) {
            if (!option.getAttributeValue("name").equals("myName")) continue;
            return option.getAttributeValue("value");
        }
        throw new IllegalStateException();
    }

    @NotNull
    protected abstract String getComponentStateFileName();

    @NotNull
    protected abstract String getSubStateTagName();
}

