/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class ServiceManager {
    private static final Logger LOG = Logger.getInstance(ServiceManager.class);

    private ServiceManager() {
    }

    public static <T> T getService(@NotNull Class<T> serviceClass) {
        Application application = ApplicationManager.getApplication();
        return ServiceManager.doGetService(application, serviceClass);
    }

    public static <T> T getService(@NotNull Project project, @NotNull Class<T> serviceClass) {
        return ServiceManager.doGetService(project, serviceClass);
    }

    @Nullable
    private static <T> T doGetService(ComponentManager componentManager, @NotNull Class<T> serviceClass) {
        PicoContainer picoContainer = componentManager.getPicoContainer();
        Object instance = picoContainer.getComponentInstance((Object)serviceClass.getName());
        if (instance == null && (instance = componentManager.getComponent(serviceClass)) != null) {
            Application app = ApplicationManager.getApplication();
            String message = serviceClass.getName() + " requested as a service, but it is a component - convert it to a service or change call to " + (componentManager == app ? "ApplicationManager.getApplication().getComponent()" : "project.getComponent()");
            if (app.isUnitTestMode()) {
                LOG.error(message);
            } else {
                LOG.warn(message);
            }
        }
        return (T)instance;
    }

    public static <T> NotNullLazyKey<T, Project> createLazyKey(@NotNull Class<T> serviceClass) {
        return NotNullLazyKey.create((String)("Service: " + serviceClass.getName()), project -> ServiceManager.getService(project, serviceClass));
    }
}

