/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.impl.patch.BinaryEncoder;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BinaryPatchContentParser {
    @NonNls
    private static final Pattern ourGitBinaryLineSize = Pattern.compile("literal\\s+(\\d+)\\s*");

    public static FilePatch readGitBinaryFormatPatch(@NotNull ListIterator<String> iterator, @NotNull FileStatus parsedStatus) throws PatchSyntaxException {
        ByteArrayOutputStream afterStream = new ByteArrayOutputStream();
        ByteArrayOutputStream beforeStream = new ByteArrayOutputStream();
        BinaryPatchContentParser.checkNotEOF(iterator);
        try {
            String next = iterator.next();
            Matcher literalMatcher = ourGitBinaryLineSize.matcher(next);
            if (literalMatcher.matches()) {
                BinaryPatchContentParser.getContent(iterator, afterStream, literalMatcher.group(1));
            }
            if (iterator.hasNext() && parsedStatus != FileStatus.ADDED) {
                next = iterator.next();
                if (StringUtil.isEmptyOrSpaces((String)next) && iterator.hasNext()) {
                    next = iterator.next();
                }
                if (literalMatcher.reset(next).matches()) {
                    BinaryPatchContentParser.getContent(iterator, beforeStream, literalMatcher.group(1));
                } else {
                    iterator.previous();
                }
            }
            return new BinaryFilePatch(parsedStatus == FileStatus.ADDED ? null : beforeStream.toByteArray(), parsedStatus == FileStatus.DELETED ? null : afterStream.toByteArray());
        }
        catch (Exception e) {
            throw new PatchSyntaxException(iterator.previousIndex(), e.getMessage());
        }
    }

    private static void getContent(@NotNull ListIterator<String> iterator, @NotNull ByteArrayOutputStream afterStream, @NotNull String lenFromLiteral) throws EofBinaryPatchSyntaxException, IOException, BinaryEncoder.BinaryPatchException {
        long afterSize = Long.parseLong(lenFromLiteral);
        BinaryPatchContentParser.checkNotEOF(iterator);
        BinaryEncoder.decode(iterator, afterSize, afterStream);
    }

    private static void checkNotEOF(@NotNull ListIterator<String> iterator) throws EofBinaryPatchSyntaxException {
        if (!iterator.hasNext()) {
            throw new EofBinaryPatchSyntaxException(iterator.previousIndex());
        }
    }

    public static class EofBinaryPatchSyntaxException
    extends PatchSyntaxException {
        public EofBinaryPatchSyntaxException(int line) {
            super(line, "Unexpected end of binary patch");
        }
    }
}

