/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorTypedHandlerBean;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.actionSystem.TypedActionHandlerEx;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.reporting.FreezeLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypedAction {
    @NotNull
    private TypedActionHandler myRawHandler;
    private TypedActionHandler myHandler = new Handler();
    private boolean myHandlersLoaded;

    public TypedAction() {
        this.myRawHandler = new DefaultRawHandler();
    }

    private void ensureHandlersLoaded() {
        if (!this.myHandlersLoaded) {
            this.myHandlersLoaded = true;
            for (EditorTypedHandlerBean handlerBean : (EditorTypedHandlerBean[])Extensions.getExtensions(EditorTypedHandlerBean.EP_NAME)) {
                this.myHandler = handlerBean.getHandler(this.myHandler);
            }
        }
    }

    public TypedActionHandler getHandler() {
        this.ensureHandlersLoaded();
        return this.myHandler;
    }

    public TypedActionHandler setupHandler(TypedActionHandler handler) {
        this.ensureHandlersLoaded();
        TypedActionHandler tmp = this.myHandler;
        this.myHandler = handler;
        return tmp;
    }

    @NotNull
    public TypedActionHandler getRawHandler() {
        return this.myRawHandler;
    }

    @NotNull
    public TypedActionHandler setupRawHandler(@NotNull TypedActionHandler handler) {
        TypedActionHandler tmp = this.myRawHandler;
        this.myRawHandler = handler;
        return tmp;
    }

    public void beforeActionPerformed(@NotNull Editor editor, char c, @NotNull DataContext context, @NotNull ActionPlan plan) {
        if (this.myRawHandler instanceof TypedActionHandlerEx) {
            ((TypedActionHandlerEx)this.myRawHandler).beforeExecute(editor, c, context, plan);
        }
    }

    public final void actionPerformed(@Nullable Editor editor, char charTyped, DataContext dataContext) {
        if (editor == null) {
            return;
        }
        Project project = CommonDataKeys.PROJECT.getData(dataContext);
        FreezeLogger.getInstance().runUnderPerformanceMonitor(project, () -> this.myRawHandler.execute(editor, charTyped, dataContext));
    }

    private class DefaultRawHandler
    implements TypedActionHandlerEx {
        private DefaultRawHandler() {
        }

        @Override
        public void beforeExecute(@NotNull Editor editor, char c, @NotNull DataContext context, @NotNull ActionPlan plan) {
            if (editor.isViewer() || !editor.getDocument().isWritable()) {
                return;
            }
            TypedActionHandler handler = TypedAction.this.getHandler();
            if (handler instanceof TypedActionHandlerEx) {
                ((TypedActionHandlerEx)handler).beforeExecute(editor, c, context, plan);
            }
        }

        @Override
        public void execute(final @NotNull Editor editor, final char charTyped, final @NotNull DataContext dataContext) {
            CommandProcessor.getInstance().executeCommand(CommonDataKeys.PROJECT.getData(dataContext), () -> {
                if (!EditorModificationUtil.requestWriting(editor)) {
                    HintManager.getInstance().showInformationHint(editor, "File is not writable");
                    return;
                }
                ApplicationManager.getApplication().runWriteAction(new DocumentRunnable(editor.getDocument(), editor.getProject()){

                    @Override
                    public void run() {
                        Document doc = editor.getDocument();
                        doc.startGuardedBlockChecking();
                        try {
                            TypedAction.this.getHandler().execute(editor, charTyped, dataContext);
                        }
                        catch (ReadOnlyFragmentModificationException e) {
                            EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
                        }
                        finally {
                            doc.stopGuardedBlockChecking();
                        }
                    }
                });
            }, "", (Object)editor.getDocument(), UndoConfirmationPolicy.DEFAULT, editor.getDocument());
        }
    }

    private static class Handler
    implements TypedActionHandler {
        private Handler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
            if (editor.isViewer()) {
                return;
            }
            Document doc = editor.getDocument();
            doc.startGuardedBlockChecking();
            try {
                String str = String.valueOf(charTyped);
                CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message("typing.in.editor.command.name", new Object[0]));
                EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets(editor, str, true);
            }
            catch (ReadOnlyFragmentModificationException e) {
                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
            }
            finally {
                doc.stopGuardedBlockChecking();
            }
        }
    }
}

