/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorColorsUtil {
    private EditorColorsUtil() {
    }

    @NotNull
    public static EditorColorsScheme getGlobalOrDefaultColorScheme() {
        return EditorColorsUtil.getColorSchemeForBackground(null);
    }

    @Nullable
    public static Color getGlobalOrDefaultColor(@NotNull ColorKey colorKey) {
        return EditorColorsUtil.getColorSchemeForBackground(null).getColor(colorKey);
    }

    @NotNull
    public static EditorColorsScheme getColorSchemeForComponent(@Nullable JComponent component) {
        return EditorColorsUtil.getColorSchemeForBackground(component != null ? component.getBackground() : null);
    }

    public static EditorColorsScheme getColorSchemeForBackground(@Nullable Color background) {
        EditorColorsScheme scheme;
        EditorColorsScheme globalScheme;
        boolean dark2;
        boolean dark1 = background == null ? UIUtil.isUnderDarcula() : ColorUtil.isDark((Color)background);
        if (dark1 != (dark2 = ColorUtil.isDark((Color)(globalScheme = EditorColorsManager.getInstance().getGlobalScheme()).getDefaultBackground())) && (scheme = EditorColorsManager.getInstance().getScheme("Default")) != null) {
            return scheme;
        }
        return globalScheme;
    }
}

