/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.Identifiable;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleData
extends AbstractNamedData
implements Named,
ExternalConfigPathAware,
Identifiable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final Map<ExternalSystemSourceType, String> myCompileOutputPaths = ContainerUtil.newHashMap();
    @NotNull
    private final String myId;
    @NotNull
    private final String myModuleTypeId;
    @NotNull
    private final String myExternalConfigPath;
    @NotNull
    private String myModuleFileDirectoryPath;
    @Nullable
    private String myGroup;
    @Nullable
    private String myVersion;
    @Nullable
    private String myDescription;
    @NotNull
    private List<File> myArtifacts;
    @Nullable
    private String[] myIdeModuleGroup;
    @Nullable
    private String mySourceCompatibility;
    @Nullable
    private String myTargetCompatibility;
    @Nullable
    private String myProductionModuleId;
    private boolean myInheritProjectCompileOutputPath = true;

    public ModuleData(@NotNull String id, @NotNull ProjectSystemId owner, @NotNull String typeId, @NotNull String name, @NotNull String moduleFileDirectoryPath, @NotNull String externalConfigPath) {
        super(owner, name, name.replaceAll("(/|\\\\)", "_"));
        this.myId = id;
        this.myModuleTypeId = typeId;
        this.myExternalConfigPath = externalConfigPath;
        this.myArtifacts = Collections.emptyList();
        this.myModuleFileDirectoryPath = moduleFileDirectoryPath;
    }

    protected ModuleData(@NotNull String id, @NotNull ProjectSystemId owner, @NotNull String typeId, @NotNull String externalName, @NotNull String internalName, @NotNull String moduleFileDirectoryPath, @NotNull String externalConfigPath) {
        super(owner, externalName, internalName);
        this.myId = id;
        this.myModuleTypeId = typeId;
        this.myExternalConfigPath = externalConfigPath;
        this.myArtifacts = Collections.emptyList();
        this.myModuleFileDirectoryPath = moduleFileDirectoryPath;
    }

    @Override
    @NotNull
    public String getId() {
        return this.myId;
    }

    @NotNull
    public String getModuleTypeId() {
        return this.myModuleTypeId;
    }

    @Override
    @NotNull
    public String getLinkedExternalProjectPath() {
        return this.myExternalConfigPath;
    }

    @NotNull
    public String getModuleFilePath() {
        return ExternalSystemApiUtil.toCanonicalPath(this.myModuleFileDirectoryPath + "/" + this.getInternalName() + ".iml");
    }

    @NotNull
    public String getModuleFileDirectoryPath() {
        return this.myModuleFileDirectoryPath;
    }

    public void setModuleFileDirectoryPath(@NotNull String path2) {
        this.myModuleFileDirectoryPath = path2;
    }

    @Nullable
    public String getProductionModuleId() {
        return this.myProductionModuleId;
    }

    public void setProductionModuleId(@Nullable String productionModuleId) {
        this.myProductionModuleId = productionModuleId;
    }

    public boolean isInheritProjectCompileOutputPath() {
        return this.myInheritProjectCompileOutputPath;
    }

    public void setInheritProjectCompileOutputPath(boolean inheritProjectCompileOutputPath) {
        this.myInheritProjectCompileOutputPath = inheritProjectCompileOutputPath;
    }

    @Nullable
    public String getCompileOutputPath(@NotNull ExternalSystemSourceType type) {
        return this.myCompileOutputPaths.get(type);
    }

    public void setCompileOutputPath(@NotNull ExternalSystemSourceType type, @Nullable String path2) {
        if (path2 == null) {
            this.myCompileOutputPaths.remove(type);
            return;
        }
        this.myCompileOutputPaths.put(type, ExternalSystemApiUtil.toCanonicalPath(path2));
    }

    @Nullable
    public String getGroup() {
        return this.myGroup;
    }

    public void setGroup(@Nullable String group) {
        this.myGroup = group;
    }

    @Nullable
    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(@Nullable String version) {
        this.myVersion = version;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nullable String description) {
        this.myDescription = description;
    }

    @NotNull
    public List<File> getArtifacts() {
        return this.myArtifacts;
    }

    public void setArtifacts(@NotNull List<File> artifacts) {
        this.myArtifacts = artifacts;
    }

    @Nullable
    public String[] getIdeModuleGroup() {
        return this.myIdeModuleGroup;
    }

    public void setIdeModuleGroup(@Nullable String[] ideModuleGroup) {
        this.myIdeModuleGroup = ideModuleGroup;
    }

    @Nullable
    public String getSourceCompatibility() {
        return this.mySourceCompatibility;
    }

    public void setSourceCompatibility(@Nullable String sourceCompatibility) {
        this.mySourceCompatibility = sourceCompatibility;
    }

    @Nullable
    public String getTargetCompatibility() {
        return this.myTargetCompatibility;
    }

    public void setTargetCompatibility(@Nullable String targetCompatibility) {
        this.myTargetCompatibility = targetCompatibility;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ModuleData)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModuleData that = (ModuleData)o;
        if (!this.myId.equals(that.myId)) {
            return false;
        }
        if (this.myGroup != null ? !this.myGroup.equals(that.myGroup) : that.myGroup != null) {
            return false;
        }
        if (!this.myModuleTypeId.equals(that.myModuleTypeId)) {
            return false;
        }
        if (this.myVersion != null ? !this.myVersion.equals(that.myVersion) : that.myVersion != null) {
            return false;
        }
        return !(this.myDescription != null ? !this.myDescription.equals(that.myDescription) : that.myDescription != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myId.hashCode();
        result = 31 * result + this.myModuleTypeId.hashCode();
        result = 31 * result + (this.myGroup != null ? this.myGroup.hashCode() : 0);
        result = 31 * result + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        result = 31 * result + (this.myDescription != null ? this.myDescription.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getId();
    }
}

