/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.Identifiable;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectData
extends AbstractNamedData
implements ExternalConfigPathAware,
Identifiable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myLinkedExternalProjectPath;
    @NotNull
    private String myIdeProjectFileDirectoryPath;
    @Nullable
    private String myDescription;
    private String myGroup;
    private String myVersion;

    @Deprecated
    public ProjectData(@NotNull ProjectSystemId owner, @NotNull String ideProjectFileDirectoryPath, @NotNull String linkedExternalProjectPath) {
        super(owner, "unnamed");
        this.myLinkedExternalProjectPath = ExternalSystemApiUtil.toCanonicalPath(linkedExternalProjectPath);
        this.myIdeProjectFileDirectoryPath = ExternalSystemApiUtil.toCanonicalPath(ideProjectFileDirectoryPath);
    }

    public ProjectData(@NotNull ProjectSystemId owner, @NotNull String externalName, @NotNull String ideProjectFileDirectoryPath, @NotNull String linkedExternalProjectPath) {
        super(owner, externalName);
        this.myLinkedExternalProjectPath = ExternalSystemApiUtil.toCanonicalPath(linkedExternalProjectPath);
        this.myIdeProjectFileDirectoryPath = ExternalSystemApiUtil.toCanonicalPath(ideProjectFileDirectoryPath);
    }

    @Override
    @Deprecated
    public void setName(@NotNull String name) {
        super.setExternalName(name);
        super.setInternalName(name);
    }

    @NotNull
    public String getIdeProjectFileDirectoryPath() {
        return this.myIdeProjectFileDirectoryPath;
    }

    public void setIdeProjectFileDirectoryPath(@NotNull String ideProjectFileDirectoryPath) {
        this.myIdeProjectFileDirectoryPath = ExternalSystemApiUtil.toCanonicalPath(ideProjectFileDirectoryPath);
    }

    @Override
    @NotNull
    public String getLinkedExternalProjectPath() {
        return this.myLinkedExternalProjectPath;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myIdeProjectFileDirectoryPath.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectData project = (ProjectData)o;
        return this.myIdeProjectFileDirectoryPath.equals(project.myIdeProjectFileDirectoryPath);
    }

    public String toString() {
        return String.format("%s project '%s'", this.getOwner().toString().toLowerCase(), this.getExternalName());
    }

    @Override
    @NotNull
    public String getId() {
        return "";
    }

    public String getGroup() {
        return this.myGroup;
    }

    public void setGroup(String group) {
        this.myGroup = group;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public void setVersion(String version) {
        this.myVersion = version;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nullable String description) {
        this.myDescription = description;
    }
}

