/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.settings;

import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DelegatingExternalSystemSettingsListener<S extends ExternalProjectSettings>
implements ExternalSystemSettingsListener<S> {
    @NotNull
    private final ExternalSystemSettingsListener<S> myDelegate;

    public DelegatingExternalSystemSettingsListener(@NotNull ExternalSystemSettingsListener<S> delegate) {
        this.myDelegate = delegate;
    }

    @Override
    public void onProjectRenamed(@NotNull String oldName, @NotNull String newName) {
        this.myDelegate.onProjectRenamed(oldName, newName);
    }

    @Override
    public void onProjectsLinked(@NotNull Collection<S> settings) {
        this.myDelegate.onProjectsLinked(settings);
    }

    @Override
    public void onProjectsUnlinked(@NotNull Set<String> linkedProjectPaths) {
        this.myDelegate.onProjectsUnlinked(linkedProjectPaths);
    }

    @Override
    public void onUseAutoImportChange(boolean currentValue, @NotNull String linkedProjectPath) {
        this.myDelegate.onUseAutoImportChange(currentValue, linkedProjectPath);
    }

    @Override
    public void onBulkChangeStart() {
        this.myDelegate.onBulkChangeStart();
    }

    @Override
    public void onBulkChangeEnd() {
        this.myDelegate.onBulkChangeEnd();
    }
}

