/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.service.ParametersEnhancer;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.util.ArtifactInfo;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Consumer;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemApiUtil {
    private static final Logger LOG = Logger.getInstance((String)("#" + ExternalSystemApiUtil.class.getName()));
    private static final String LAST_USED_PROJECT_PATH_PREFIX = "LAST_EXTERNAL_PROJECT_PATH_";
    @NotNull
    public static final String PATH_SEPARATOR = "/";
    @NotNull
    private static final Pattern ARTIFACT_PATTERN = Pattern.compile("(?:.*/)?(.+?)(?:-([\\d+](?:\\.[\\d]+)*))?(?:\\.[^\\.]+?)?");
    @NotNull
    public static final Comparator<Object> ORDER_AWARE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(@NotNull Object o1, @NotNull Object o2) {
            int order2;
            int order1 = this.getOrder(o1);
            return order1 < (order2 = this.getOrder(o2)) ? -1 : (order1 == order2 ? 0 : 1);
        }

        private int getOrder(@NotNull Object o) {
            ArrayDeque toCheck = new ArrayDeque();
            toCheck.add(o.getClass());
            while (!toCheck.isEmpty()) {
                Class clazz = (Class)toCheck.poll();
                Order annotation = clazz.getAnnotation(Order.class);
                if (annotation != null) {
                    return annotation.value();
                }
                Class c = clazz.getSuperclass();
                if (c != null) {
                    toCheck.add(c);
                }
                Class<?>[] interfaces = clazz.getInterfaces();
                Collections.addAll(toCheck, interfaces);
            }
            return 1000;
        }
    };
    @NotNull
    private static final NullableFunction<DataNode<?>, Key<?>> GROUPER = node -> node.getKey();
    @NotNull
    private static final TransferToEDTQueue<Runnable> TRANSFER_TO_EDT_QUEUE = new TransferToEDTQueue("External System queue", runnable -> {
        runnable.run();
        return true;
    }, Conditions.alwaysFalse(), 300);

    private ExternalSystemApiUtil() {
    }

    @NotNull
    public static String extractNameFromPath(@NotNull String path2) {
        String strippedPath = ExternalSystemApiUtil.stripPath(path2);
        int i2 = strippedPath.lastIndexOf(PATH_SEPARATOR);
        String result = i2 < 0 || i2 >= strippedPath.length() - 1 ? strippedPath : strippedPath.substring(i2 + 1);
        return result;
    }

    @NotNull
    private static String stripPath(@NotNull String path2) {
        String[] endingsToStrip = new String[]{PATH_SEPARATOR, "!", ".jar"};
        StringBuilder buffer = new StringBuilder(path2);
        for (String ending : endingsToStrip) {
            if (buffer.lastIndexOf(ending) != buffer.length() - ending.length()) continue;
            buffer.setLength(buffer.length() - ending.length());
        }
        return buffer.toString();
    }

    @NotNull
    public static String getLibraryName(@NotNull Library library) {
        String result = library.getName();
        if (result != null) {
            return result;
        }
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            for (String url : library.getUrls(type)) {
                String candidate = ExternalSystemApiUtil.extractNameFromPath(url);
                if (StringUtil.isEmpty((String)candidate)) continue;
                return candidate;
            }
        }
        assert (false);
        return "unknown-lib";
    }

    public static boolean isRelated(@NotNull Library library, @NotNull LibraryData libraryData) {
        return ExternalSystemApiUtil.getLibraryName(library).equals(libraryData.getInternalName());
    }

    public static boolean isExternalSystemLibrary(@NotNull Library library, @NotNull ProjectSystemId externalSystemId) {
        return library.getName() != null && StringUtil.startsWith((CharSequence)library.getName(), (CharSequence)(externalSystemId.getReadableName() + ": "));
    }

    @Nullable
    public static ArtifactInfo parseArtifactInfo(@NotNull String fileName) {
        Matcher matcher = ARTIFACT_PATTERN.matcher(fileName);
        if (!matcher.matches()) {
            return null;
        }
        return new ArtifactInfo(matcher.group(1), null, matcher.group(2));
    }

    public static void orderAwareSort(@NotNull List<?> data) {
        Collections.sort(data, ORDER_AWARE_COMPARATOR);
    }

    @NotNull
    public static String toCanonicalPath(@NotNull String path2) {
        String p = ExternalSystemApiUtil.normalizePath(new File(path2).getAbsolutePath());
        assert (p != null);
        return PathUtil.getCanonicalPath(p);
    }

    @NotNull
    public static String getLocalFileSystemPath(@NotNull VirtualFile file) {
        VirtualFile jar;
        if (file.getFileType() == FileTypes.ARCHIVE && (jar = JarFileSystem.getInstance().getVirtualFileForJar(file)) != null) {
            return jar.getPath();
        }
        return ExternalSystemApiUtil.toCanonicalPath(file.getPath());
    }

    @Nullable
    public static ExternalSystemManager<?, ?, ?, ?, ?> getManager(@NotNull ProjectSystemId externalSystemId) {
        for (ExternalSystemManager manager : (ExternalSystemManager[])ExternalSystemManager.EP_NAME.getExtensions()) {
            if (!externalSystemId.equals(manager.getSystemId())) continue;
            return manager;
        }
        return null;
    }

    @NotNull
    public static Collection<ExternalSystemManager<?, ?, ?, ?, ?>> getAllManagers() {
        ArrayList result = ContainerUtilRt.newArrayList();
        for (ExternalSystemManager manager : (ExternalSystemManager[])ExternalSystemManager.EP_NAME.getExtensions()) {
            result.add(manager);
        }
        return result;
    }

    public static MultiMap<Key<?>, DataNode<?>> recursiveGroup(@NotNull Collection<DataNode<?>> nodes) {
        ContainerUtil.KeyOrderedMultiMap result = new ContainerUtil.KeyOrderedMultiMap();
        LinkedList queue = ContainerUtil.newLinkedList();
        queue.add(nodes);
        while (!queue.isEmpty()) {
            Collection _nodes = (Collection)queue.remove();
            result.putAllValues(ExternalSystemApiUtil.group(_nodes));
            for (DataNode _node : _nodes) {
                queue.add(_node.getChildren());
            }
        }
        return result;
    }

    @NotNull
    public static MultiMap<Key<?>, DataNode<?>> group(@NotNull Collection<DataNode<?>> nodes) {
        return ContainerUtil.groupBy(nodes, GROUPER);
    }

    @NotNull
    public static <K, V> MultiMap<DataNode<K>, DataNode<V>> groupBy(@NotNull Collection<DataNode<V>> nodes, Class<K> moduleDataClass) {
        return ContainerUtil.groupBy(nodes, node -> node.getParent(moduleDataClass));
    }

    @NotNull
    public static <K, V> MultiMap<DataNode<K>, DataNode<V>> groupBy(@NotNull Collection<DataNode<V>> nodes, @NotNull Key<K> key) {
        return ContainerUtil.groupBy(nodes, node -> node.getDataNode(key));
    }

    @NotNull
    public static <T> Collection<DataNode<T>> getChildren(@NotNull DataNode<?> node, @NotNull Key<T> key) {
        ArrayList result = null;
        for (DataNode<?> child : node.getChildren()) {
            if (!key.equals(child.getKey())) continue;
            if (result == null) {
                result = ContainerUtilRt.newArrayList();
            }
            result.add(child);
        }
        return result == null ? Collections.emptyList() : result;
    }

    @Nullable
    public static <T> DataNode<T> find(@NotNull DataNode<?> node, @NotNull Key<T> key) {
        for (DataNode<?> child : node.getChildren()) {
            if (!key.equals(child.getKey())) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static <T> DataNode<T> find(@NotNull DataNode<?> node, @NotNull Key<T> key, BooleanFunction<DataNode<T>> predicate) {
        for (DataNode<?> child : node.getChildren()) {
            if (!key.equals(child.getKey()) || !predicate.fun(child)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static <T> DataNode<T> findParent(@NotNull DataNode<?> node, @NotNull Key<T> key) {
        return ExternalSystemApiUtil.findParent(node, key, null);
    }

    @Nullable
    public static <T> DataNode<T> findParent(@NotNull DataNode<?> node, @NotNull Key<T> key, @Nullable BooleanFunction<DataNode<T>> predicate) {
        DataNode<?> parent = node.getParent();
        if (parent == null) {
            return null;
        }
        return key.equals(parent.getKey()) && (predicate == null || predicate.fun(parent)) ? parent : ExternalSystemApiUtil.findParent(parent, key, predicate);
    }

    @NotNull
    public static <T> Collection<DataNode<T>> findAll(@NotNull DataNode<?> parent, @NotNull Key<T> key) {
        return ExternalSystemApiUtil.getChildren(parent, key);
    }

    public static void visit(@Nullable DataNode node, @NotNull Consumer<DataNode<?>> consumer) {
        if (node == null) {
            return;
        }
        Stack toProcess = ContainerUtil.newStack((Object[])new DataNode[]{node});
        while (!toProcess.isEmpty()) {
            DataNode node0 = (DataNode)toProcess.pop();
            consumer.consume((Object)node0);
            for (DataNode<?> child : node0.getChildren()) {
                toProcess.push(child);
            }
        }
    }

    @NotNull
    public static <T> Collection<DataNode<T>> findAllRecursively(@Nullable DataNode<?> node, @NotNull Key<T> key) {
        if (node == null) {
            return Collections.emptyList();
        }
        Collection<DataNode<?>> nodes = ExternalSystemApiUtil.findAllRecursively(node.getChildren(), node1 -> node1.getKey().equals(key));
        return new SmartList(nodes);
    }

    @NotNull
    public static Collection<DataNode<?>> findAllRecursively(@NotNull Collection<DataNode<?>> nodes) {
        return ExternalSystemApiUtil.findAllRecursively(nodes, null);
    }

    @NotNull
    public static Collection<DataNode<?>> findAllRecursively(@Nullable DataNode<?> node, @Nullable BooleanFunction<DataNode<?>> predicate) {
        if (node == null) {
            return Collections.emptyList();
        }
        return ExternalSystemApiUtil.findAllRecursively(node.getChildren(), predicate);
    }

    @NotNull
    public static Collection<DataNode<?>> findAllRecursively(@NotNull Collection<DataNode<?>> nodes, @Nullable BooleanFunction<DataNode<?>> predicate) {
        SmartList result = new SmartList();
        for (DataNode<?> node : nodes) {
            if (predicate != null && !predicate.fun(node)) continue;
            result.add(node);
        }
        for (DataNode<?> node : nodes) {
            result.addAll(ExternalSystemApiUtil.findAllRecursively(node.getChildren(), predicate));
        }
        return result;
    }

    @Nullable
    public static DataNode<?> findFirstRecursively(@NotNull DataNode<?> parentNode, @NotNull BooleanFunction<DataNode<?>> predicate) {
        LinkedList queue = new LinkedList();
        queue.add(parentNode);
        return ExternalSystemApiUtil.findInQueue(queue, predicate);
    }

    @Nullable
    public static DataNode<?> findFirstRecursively(@NotNull Collection<DataNode<?>> nodes, @NotNull BooleanFunction<DataNode<?>> predicate) {
        return ExternalSystemApiUtil.findInQueue(new LinkedList(nodes), predicate);
    }

    @Nullable
    private static DataNode<?> findInQueue(@NotNull Queue<DataNode<?>> queue, @NotNull BooleanFunction<DataNode<?>> predicate) {
        while (!queue.isEmpty()) {
            DataNode<?> node = queue.remove();
            if (predicate.fun(node)) {
                return node;
            }
            queue.addAll(node.getChildren());
        }
        return null;
    }

    public static void commitChangedModels(boolean synchronous, Project project, List<Library.ModifiableModel> models) {
        final List changedModels = ContainerUtil.findAll(models, model -> model.isChanged());
        if (!changedModels.isEmpty()) {
            ExternalSystemApiUtil.executeProjectChangeAction(synchronous, new DisposeAwareProjectChange(project){

                @Override
                public void execute() {
                    for (Library.ModifiableModel modifiableModel : changedModels) {
                        modifiableModel.commit();
                    }
                }
            });
        }
    }

    public static void disposeModels(@NotNull Collection<ModifiableRootModel> models) {
        for (ModifiableRootModel model : models) {
            if (model.isDisposed()) continue;
            model.dispose();
        }
    }

    public static void commitModels(boolean synchronous, Project project, List<ModifiableRootModel> models) {
        final ArrayList changedModels = ContainerUtilRt.newArrayList();
        for (ModifiableRootModel modifiableRootModel : models) {
            if (modifiableRootModel.isDisposed()) continue;
            if (modifiableRootModel.isChanged()) {
                changedModels.add(modifiableRootModel);
                continue;
            }
            modifiableRootModel.dispose();
        }
        if (!changedModels.isEmpty()) {
            ExternalSystemApiUtil.executeProjectChangeAction(synchronous, new DisposeAwareProjectChange(project){

                @Override
                public void execute() {
                    for (ModifiableRootModel modifiableRootModel : changedModels) {
                        if (modifiableRootModel.isDisposed()) continue;
                        modifiableRootModel.commit();
                    }
                }
            });
        }
    }

    public static void executeProjectChangeAction(@NotNull DisposeAwareProjectChange task) {
        ExternalSystemApiUtil.executeProjectChangeAction(true, task);
    }

    public static void executeProjectChangeAction(boolean synchronous, @NotNull DisposeAwareProjectChange task) {
        ExternalSystemApiUtil.executeOnEdt(synchronous, () -> ApplicationManager.getApplication().runWriteAction(() -> task.run()));
    }

    public static void executeOnEdt(boolean synchronous, @NotNull Runnable task) {
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            task.run();
            return;
        }
        if (synchronous) {
            app.invokeAndWait(task);
        } else {
            app.invokeLater(task);
        }
    }

    public static <T> T executeOnEdt(@NotNull Computable<T> task) {
        Application app = ApplicationManager.getApplication();
        Ref result = Ref.create();
        app.invokeAndWait(() -> result.set(task.compute()));
        return (T)result.get();
    }

    public static <T> T doWriteAction(@NotNull Computable<T> task) {
        return ExternalSystemApiUtil.executeOnEdt(() -> ApplicationManager.getApplication().runWriteAction(task));
    }

    public static void doWriteAction(@NotNull Runnable task) {
        ExternalSystemApiUtil.executeOnEdt(true, () -> ApplicationManager.getApplication().runWriteAction(task));
    }

    public static void addToInvokeLater(Runnable runnable) {
        Application application = ApplicationManager.getApplication();
        boolean unitTestMode = application.isUnitTestMode();
        if (unitTestMode) {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable);
        } else if (application.isHeadlessEnvironment() || application.isDispatchThread()) {
            runnable.run();
        } else {
            TRANSFER_TO_EDT_QUEUE.offer((Object)runnable);
        }
    }

    public static void addBundle(@NotNull PathsList classPath, @NotNull String bundlePath, @NotNull Class<?> contextClass) {
        String root;
        String pathToUse = bundlePath.replace('.', '/');
        if (!pathToUse.endsWith(".properties")) {
            pathToUse = pathToUse + ".properties";
        }
        if (!pathToUse.startsWith(PATH_SEPARATOR)) {
            pathToUse = '/' + pathToUse;
        }
        if ((root = PathManager.getResourceRoot(contextClass, (String)pathToUse)) != null) {
            classPath.add(root);
        }
    }

    @Nullable
    public static String normalizePath(@Nullable String s) {
        return StringUtil.isEmpty((String)s) ? null : s.replace('\\', '/');
    }

    public static boolean isOneToOneMapping(@NotNull Project ideProject, @NotNull ProjectData projectData) {
        String linkedExternalProjectPath = null;
        for (ExternalSystemManager<?, ?, ?, ?, ?> manager : ExternalSystemApiUtil.getAllManagers()) {
            ProjectSystemId externalSystemId = manager.getSystemId();
            AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings(ideProject, externalSystemId);
            Collection projectsSettings = systemSettings.getLinkedProjectsSettings();
            int linkedProjectsNumber = projectsSettings.size();
            if (linkedProjectsNumber > 1) {
                return false;
            }
            if (linkedProjectsNumber != 1) continue;
            if (linkedExternalProjectPath == null) {
                linkedExternalProjectPath = ((ExternalProjectSettings)projectsSettings.iterator().next()).getExternalProjectPath();
                continue;
            }
            return false;
        }
        if (linkedExternalProjectPath != null && !linkedExternalProjectPath.equals(projectData.getLinkedExternalProjectPath())) {
            return false;
        }
        for (Module module : ModuleManager.getInstance(ideProject).getModules()) {
            if (ExternalSystemApiUtil.isExternalSystemAwareModule(projectData.getOwner(), module)) continue;
            return false;
        }
        return true;
    }

    public static void storeLastUsedExternalProjectPath(@Nullable String path2, @NotNull ProjectSystemId externalSystemId) {
        if (path2 != null) {
            PropertiesComponent.getInstance().setValue(LAST_USED_PROJECT_PATH_PREFIX + externalSystemId.getReadableName(), path2);
        }
    }

    @NotNull
    public static String getProjectRepresentationName(@NotNull String targetProjectPath, @Nullable String rootProjectPath) {
        File targetProjectDir;
        if (rootProjectPath == null) {
            File rootProjectDir = new File(targetProjectPath);
            if (rootProjectDir.isFile()) {
                rootProjectDir = rootProjectDir.getParentFile();
            }
            return rootProjectDir.getName();
        }
        File rootProjectDir = new File(rootProjectPath);
        if (rootProjectDir.isFile()) {
            rootProjectDir = rootProjectDir.getParentFile();
        }
        if ((targetProjectDir = new File(targetProjectPath)).isFile()) {
            targetProjectDir = targetProjectDir.getParentFile();
        }
        StringBuilder buffer = new StringBuilder();
        for (File f = targetProjectDir; f != null && !FileUtil.filesEqual((File)f, (File)rootProjectDir); f = f.getParentFile()) {
            buffer.insert(0, f.getName()).insert(0, ":");
        }
        buffer.insert(0, rootProjectDir.getName());
        return buffer.toString();
    }

    @Nullable
    public static String getRootProjectPath(@NotNull String externalProjectPath, @NotNull ProjectSystemId externalSystemId, @NotNull Project project) {
        ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(externalSystemId);
        if (manager == null) {
            return null;
        }
        if (manager instanceof ExternalSystemAutoImportAware) {
            return ((ExternalSystemAutoImportAware)((Object)manager)).getAffectedExternalProjectPath(externalProjectPath, project);
        }
        return null;
    }

    @NotNull
    public static String buildErrorMessage(@NotNull Throwable e) {
        Throwable unwrapped = RemoteUtil.unwrap((Throwable)e);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return ExternalSystemApiUtil.stacktraceAsString(unwrapped);
        }
        String reason = unwrapped.getLocalizedMessage();
        if (!StringUtil.isEmpty((String)reason)) {
            return reason;
        }
        if (unwrapped.getClass() == ExternalSystemException.class) {
            return String.format("exception during working with external system: %s", ((ExternalSystemException)unwrapped).getOriginalReason());
        }
        return ExternalSystemApiUtil.stacktraceAsString(unwrapped);
    }

    private static String stacktraceAsString(Throwable unwrapped) {
        StringWriter writer = new StringWriter();
        unwrapped.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    @NotNull
    public static AbstractExternalSystemSettings getSettings(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) throws IllegalArgumentException {
        ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(externalSystemId);
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Can't retrieve external system settings for id '%s'. Reason: no such external system is registered", externalSystemId.getReadableName()));
        }
        return (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project);
    }

    public static <S extends AbstractExternalSystemLocalSettings> S getLocalSettings(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) throws IllegalArgumentException {
        ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(externalSystemId);
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Can't retrieve local external system settings for id '%s'. Reason: no such external system is registered", externalSystemId.getReadableName()));
        }
        return (S)((AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project));
    }

    public static <S extends ExternalSystemExecutionSettings> S getExecutionSettings(@NotNull Project project, @NotNull String linkedProjectPath, @NotNull ProjectSystemId externalSystemId) throws IllegalArgumentException {
        ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(externalSystemId);
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Can't retrieve external system execution settings for id '%s'. Reason: no such external system is registered", externalSystemId.getReadableName()));
        }
        return (S)((ExternalSystemExecutionSettings)manager.getExecutionSettingsProvider().fun((Object)Pair.create((Object)project, (Object)linkedProjectPath)));
    }

    public static boolean isInProcessMode(ProjectSystemId externalSystemId) {
        return Registry.is((String)(externalSystemId.getId() + ".system.in.process"), (boolean)false);
    }

    @NotNull
    public static <T extends ParametersEnhancer> T reloadIfNecessary(final @NotNull Class<T> clazz) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        ParametersEnhancer instance = (ParametersEnhancer)clazz.newInstance();
        ArrayList urls = ContainerUtilRt.newArrayList();
        instance.enhanceLocalProcessing(urls);
        if (urls.isEmpty()) {
            return (T)instance;
        }
        final ClassLoader baseLoader = clazz.getClassLoader();
        Method method = baseLoader.getClass().getMethod("getUrls", new Class[0]);
        if (method != null) {
            urls.addAll((Collection)method.invoke((Object)baseLoader, new Object[0]));
        }
        UrlClassLoader loader = new UrlClassLoader(UrlClassLoader.build().urls((List)urls).parent(baseLoader.getParent())){

            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (name.equals(clazz.getName())) {
                    return super.loadClass(name, resolve);
                }
                try {
                    return baseLoader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    return super.loadClass(name, resolve);
                }
            }
        };
        return (T)((ParametersEnhancer)loader.loadClass(clazz.getName()).newInstance());
    }

    @Contract(value="_, null -> false", pure=true)
    public static boolean isExternalSystemAwareModule(@NotNull ProjectSystemId systemId, @Nullable Module module) {
        return module != null && !module.isDisposed() && systemId.getId().equals(module.getOptionValue("external.system.id"));
    }

    @Contract(value="_, null -> false", pure=true)
    public static boolean isExternalSystemAwareModule(@NotNull String systemId, @Nullable Module module) {
        return module != null && !module.isDisposed() && systemId.equals(module.getOptionValue("external.system.id"));
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalProjectPath(@Nullable Module module) {
        return module != null && !module.isDisposed() ? module.getOptionValue("external.linked.project.path") : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalRootProjectPath(@Nullable Module module) {
        return module != null && !module.isDisposed() ? module.getOptionValue("external.root.project.path") : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalProjectId(@Nullable Module module) {
        return module != null && !module.isDisposed() ? module.getOptionValue("external.linked.project.id") : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalProjectGroup(@Nullable Module module) {
        return module != null && !module.isDisposed() ? module.getOptionValue("external.system.module.group") : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalProjectVersion(@Nullable Module module) {
        return module != null && !module.isDisposed() ? module.getOptionValue("external.system.module.version") : null;
    }

    @Nullable
    @Contract(pure=true)
    public static String getExternalModuleType(@Nullable Module module) {
        return module != null && !module.isDisposed() ? module.getOptionValue("external.system.module.type") : null;
    }

    public static void subscribe(@NotNull Project project, @NotNull ProjectSystemId systemId, @NotNull ExternalSystemSettingsListener listener) {
        ExternalSystemApiUtil.getSettings(project, systemId).subscribe(listener);
    }
}

