/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DumbService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.project.DumbService");
    public static final Topic<DumbModeListener> DUMB_MODE = new Topic("dumb mode", DumbModeListener.class);
    private static final NotNullLazyKey<DumbService, Project> INSTANCE_KEY = ServiceManager.createLazyKey(DumbService.class);

    public abstract ModificationTracker getModificationTracker();

    public abstract boolean isDumb();

    public static boolean isDumb(@NotNull Project project) {
        return DumbService.getInstance(project).isDumb();
    }

    public abstract void runWhenSmart(@NotNull Runnable var1);

    public abstract void waitForSmartMode();

    public <T> T runReadActionInSmartMode(@NotNull Computable<T> r) {
        Ref result = new Ref();
        this.runReadActionInSmartMode(() -> result.set(r.compute()));
        return (T)result.get();
    }

    @Nullable
    public <T> T tryRunReadActionInSmartMode(@NotNull Computable<T> task, @Nullable String notification) {
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            try {
                return (T)task.compute();
            }
            catch (IndexNotReadyException e) {
                if (notification != null) {
                    this.showDumbModeNotification(notification);
                }
                return null;
            }
        }
        return this.runReadActionInSmartMode(task);
    }

    public void runReadActionInSmartMode(@NotNull Runnable r) {
        boolean success;
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            r.run();
            return;
        }
        do {
            this.waitForSmartMode();
        } while (!(success = ((Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            if (this.isDumb()) {
                return false;
            }
            r.run();
            return true;
        })).booleanValue()));
    }

    public void repeatUntilPassesInSmartMode(@NotNull Runnable r) {
        while (true) {
            this.waitForSmartMode();
            try {
                r.run();
                return;
            }
            catch (IndexNotReadyException e) {
                LOG.info((Throwable)e);
                continue;
            }
            break;
        }
    }

    public abstract void smartInvokeLater(@NotNull Runnable var1);

    public abstract void smartInvokeLater(@NotNull Runnable var1, @NotNull ModalityState var2);

    public static DumbService getInstance(@NotNull Project project) {
        return (DumbService)INSTANCE_KEY.getValue((UserDataHolder)project);
    }

    @NotNull
    public <T> List<T> filterByDumbAwareness(@NotNull T[] array) {
        return this.filterByDumbAwareness(Arrays.asList(array));
    }

    @NotNull
    public <T> List<T> filterByDumbAwareness(@NotNull Collection<T> collection) {
        if (this.isDumb()) {
            ArrayList<T> result = new ArrayList<T>(collection.size());
            for (T element : collection) {
                if (!DumbService.isDumbAware(element)) continue;
                result.add(element);
            }
            return result;
        }
        if (collection instanceof List) {
            return (List)collection;
        }
        return new ArrayList<T>(collection);
    }

    public abstract void queueTask(@NotNull DumbModeTask var1);

    public abstract void cancelTask(@NotNull DumbModeTask var1);

    public abstract void completeJustSubmittedTasks();

    public abstract JComponent wrapGently(@NotNull JComponent var1, @NotNull Disposable var2);

    public void makeDumbAware(final @NotNull JComponent component, @NotNull Disposable disposable) {
        component.setEnabled(!this.isDumb());
        this.getProject().getMessageBus().connect(disposable).subscribe(DUMB_MODE, (Object)new DumbModeListener(){

            @Override
            public void enteredDumbMode() {
                component.setEnabled(false);
            }

            @Override
            public void exitDumbMode() {
                component.setEnabled(true);
            }
        });
    }

    public abstract void showDumbModeNotification(@NotNull String var1);

    public abstract Project getProject();

    public static boolean isDumbAware(Object o) {
        if (o instanceof PossiblyDumbAware) {
            return ((PossiblyDumbAware)o).isDumbAware();
        }
        return o instanceof DumbAware;
    }

    public abstract void setAlternativeResolveEnabled(boolean var1);

    public void withAlternativeResolveEnabled(@NotNull Runnable runnable) {
        this.setAlternativeResolveEnabled(true);
        try {
            runnable.run();
        }
        finally {
            this.setAlternativeResolveEnabled(false);
        }
    }

    public <T, E extends Throwable> T computeWithAlternativeResolveEnabled(@NotNull ThrowableComputable<T, E> runnable) throws E {
        this.setAlternativeResolveEnabled(true);
        try {
            Object object = runnable.compute();
            return (T)object;
        }
        finally {
            this.setAlternativeResolveEnabled(false);
        }
    }

    public <E extends Throwable> void runWithAlternativeResolveEnabled(@NotNull ThrowableRunnable<E> runnable) throws E {
        this.setAlternativeResolveEnabled(true);
        try {
            runnable.run();
        }
        finally {
            this.setAlternativeResolveEnabled(false);
        }
    }

    public abstract boolean isAlternativeResolveEnabled();

    @Deprecated
    public static void allowStartingDumbModeInside(@NotNull DumbModePermission permission, @NotNull Runnable runnable) {
        runnable.run();
    }

    public static interface DumbModeListener {
        default public void enteredDumbMode() {
        }

        default public void exitDumbMode() {
        }
    }
}

