/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public class SdkVersionUtil {
    private static final JdkVersionDetector.ActionRunner ACTION_RUNNER = r -> ApplicationManager.getApplication().executeOnPooledThread(r);

    private SdkVersionUtil() {
    }

    @Nullable
    public static String readVersionFromProcessOutput(@NotNull String homePath, @NotNull String[] command, String versionLineMarker) {
        return JdkVersionDetector.getInstance().detectJdkVersion(homePath, ACTION_RUNNER);
    }

    @Nullable
    public static String detectJdkVersion(@NotNull String homePath) {
        return JdkVersionDetector.getInstance().detectJdkVersion(homePath, ACTION_RUNNER);
    }

    @Nullable
    public static JdkVersionDetector.JdkVersionInfo getJdkVersionInfo(@NotNull String homePath) {
        return JdkVersionDetector.getInstance().detectJdkVersionInfo(homePath, ACTION_RUNNER);
    }
}

