/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleRootModificationUtil {
    public static void addContentRoot(@NotNull Module module, @NotNull String path2) {
        ModuleRootModificationUtil.updateModel(module, (Consumer<ModifiableRootModel>)((Consumer)model -> model.addContentEntry(VfsUtilCore.pathToUrl(path2))));
    }

    public static void addModuleLibrary(@NotNull Module module, @Nullable String libName, @NotNull List<String> classesRoots, @NotNull List<String> sourceRoots) {
        ModuleRootModificationUtil.addModuleLibrary(module, libName, classesRoots, sourceRoots, DependencyScope.COMPILE);
    }

    public static void addModuleLibrary(@NotNull Module module, @Nullable String libName, @NotNull List<String> classesRoots, @NotNull List<String> sourceRoots, @NotNull DependencyScope scope) {
        ModuleRootModificationUtil.addModuleLibrary(module, libName, classesRoots, sourceRoots, Collections.emptyList(), scope);
    }

    public static void addModuleLibrary(@NotNull Module module, @Nullable String libName, @NotNull List<String> classesRoots, @NotNull List<String> sourceRoots, @NotNull List<String> excludedRoots, @NotNull DependencyScope scope) {
        ModuleRootModificationUtil.addModuleLibrary(module, libName, classesRoots, sourceRoots, excludedRoots, scope, false);
    }

    public static void addModuleLibrary(@NotNull Module module, @Nullable String libName, @NotNull List<String> classesRoots, @NotNull List<String> sourceRoots, @NotNull List<String> excludedRoots, @NotNull DependencyScope scope, boolean exported) {
        ModuleRootModificationUtil.updateModel(module, (Consumer<ModifiableRootModel>)((Consumer)model -> {
            LibraryEx library = (LibraryEx)model.getModuleLibraryTable().createLibrary(libName);
            LibraryEx.ModifiableModelEx libraryModel = library.getModifiableModel();
            for (String root : classesRoots) {
                libraryModel.addRoot(root, OrderRootType.CLASSES);
            }
            for (String root : sourceRoots) {
                libraryModel.addRoot(root, OrderRootType.SOURCES);
            }
            for (String excluded : excludedRoots) {
                libraryModel.addExcludedRoot(excluded);
            }
            LibraryOrderEntry entry = model.findLibraryOrderEntry(library);
            assert (entry != null) : library;
            entry.setScope(scope);
            entry.setExported(exported);
            ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(libraryModel::commit));
        }));
    }

    public static void addModuleLibrary(@NotNull Module module, @NotNull String classesRootUrl) {
        ModuleRootModificationUtil.addModuleLibrary(module, null, Collections.singletonList(classesRootUrl), Collections.emptyList());
    }

    public static void addDependency(@NotNull Module module, @NotNull Library library) {
        ModuleRootModificationUtil.addDependency(module, library, DependencyScope.COMPILE, false);
    }

    public static void addDependency(@NotNull Module module, @NotNull Library library, @NotNull DependencyScope scope, boolean exported) {
        ModuleRootModificationUtil.updateModel(module, (Consumer<ModifiableRootModel>)((Consumer)model -> {
            LibraryOrderEntry entry = model.addLibraryEntry(library);
            entry.setExported(exported);
            entry.setScope(scope);
        }));
    }

    public static void setModuleSdk(@NotNull Module module, @Nullable Sdk sdk) {
        ModuleRootModificationUtil.updateModel(module, (Consumer<ModifiableRootModel>)((Consumer)model -> model.setSdk(sdk)));
    }

    public static void setSdkInherited(@NotNull Module module) {
        ModuleRootModificationUtil.updateModel(module, (Consumer<ModifiableRootModel>)((Consumer)model -> model.inheritSdk()));
    }

    public static void addDependency(@NotNull Module from, @NotNull Module to) {
        ModuleRootModificationUtil.addDependency(from, to, DependencyScope.COMPILE, false);
    }

    public static void addDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope, boolean exported) {
        ModuleRootModificationUtil.updateModel(from, (Consumer<ModifiableRootModel>)((Consumer)model -> {
            ModuleOrderEntry entry = model.addModuleOrderEntry(to);
            entry.setScope(scope);
            entry.setExported(exported);
        }));
    }

    public static void updateModel(@NotNull Module module, @NotNull Consumer<ModifiableRootModel> task) {
        ModifiableRootModel model = (ModifiableRootModel)ReadAction.compute(() -> ModuleRootManager.getInstance(module).getModifiableModel());
        try {
            task.consume((Object)model);
            ApplicationManager.getApplication().invokeAndWait(() -> WriteAction.run(model::commit));
        }
        catch (Error | RuntimeException e) {
            model.dispose();
            throw e;
        }
    }

    public static void updateExcludedFolders(@NotNull Module module, @NotNull VirtualFile contentRoot, @NotNull Collection<String> urlsToUnExclude, @NotNull Collection<String> urlsToExclude) {
        ModuleRootModificationUtil.updateModel(module, (Consumer<ModifiableRootModel>)((Consumer)modifiableModel -> {
            for (ContentEntry contentEntry : modifiableModel.getContentEntries()) {
                if (!contentRoot.equals(contentEntry.getFile())) continue;
                for (String url : urlsToUnExclude) {
                    contentEntry.removeExcludeFolder(url);
                }
                for (String url : urlsToExclude) {
                    contentEntry.addExcludeFolder(url);
                }
                break;
            }
        }));
    }
}

