/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibrariesHelper;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarVersionDetectionUtil {
    private JarVersionDetectionUtil() {
    }

    @Nullable
    public static String detectJarVersion(@NotNull String detectionClass, @NotNull Module module) {
        for (OrderEntry library : ModuleRootManager.getInstance(module).getOrderEntries()) {
            VirtualFile jar;
            if (!(library instanceof LibraryOrderEntry) || (jar = LibrariesHelper.getInstance().findJarByClass(((LibraryOrderEntry)library).getLibrary(), detectionClass)) == null || !(jar.getFileSystem() instanceof JarFileSystem)) continue;
            return JarVersionDetectionUtil.getMainAttribute(jar, Attributes.Name.IMPLEMENTATION_VERSION);
        }
        return null;
    }

    @Nullable
    public static String detectJarVersion(@NotNull String detectionClass, @NotNull List<VirtualFile> files) {
        VirtualFile jarRoot = LibrariesHelper.getInstance().findRootByClass(files, detectionClass);
        return jarRoot != null && jarRoot.getFileSystem() instanceof JarFileSystem ? JarVersionDetectionUtil.getMainAttribute(jarRoot, Attributes.Name.IMPLEMENTATION_VERSION) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getMainAttribute(VirtualFile jarRoot, Attributes.Name attribute) {
        VirtualFile manifestFile = jarRoot.findFileByRelativePath("META-INF/MANIFEST.MF");
        if (manifestFile == null) return null;
        try (InputStream stream = manifestFile.getInputStream();){
            String string = new Manifest(stream).getMainAttributes().getValue(attribute);
            return string;
        }
        catch (IOException e) {
            Logger.getInstance(JarVersionDetectionUtil.class).debug((Throwable)e);
        }
        return null;
    }

    @Nullable
    public static String getBundleVersion(@NotNull File jar) {
        return JarUtil.getJarAttribute((File)jar, (Attributes.Name)new Attributes.Name("Bundle-Version"));
    }

    @Nullable
    public static String getImplementationVersion(@NotNull File jar) {
        return JarUtil.getJarAttribute((File)jar, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
    }
}

