/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.util;

import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HtmlListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class BaseTextCommentCellAppearance
implements CellAppearanceEx {
    private SimpleTextAttributes myCommentAttributes = SimpleTextAttributes.GRAY_ATTRIBUTES;
    private SimpleTextAttributes myTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;

    protected abstract Icon getIcon();

    protected abstract String getSecondaryText();

    protected abstract String getPrimaryText();

    @Override
    public void customize(@NotNull SimpleColoredComponent component) {
        component.setIcon(this.getIcon());
        component.append(this.getPrimaryText(), this.myTextAttributes);
        String secondaryText = this.getSecondaryText();
        if (!StringUtil.isEmptyOrSpaces((String)secondaryText)) {
            component.append(" (" + secondaryText + ")", this.myCommentAttributes);
        }
    }

    @Override
    public void customize(@NotNull HtmlListCellRenderer renderer) {
        renderer.setIcon(this.getIcon());
        renderer.append(this.getPrimaryText(), this.myTextAttributes);
        String secondaryText = this.getSecondaryText();
        if (!StringUtil.isEmptyOrSpaces((String)secondaryText)) {
            renderer.append(" (" + secondaryText + ")", this.myCommentAttributes);
        }
    }

    @Override
    @NotNull
    public String getText() {
        String secondaryText = this.getSecondaryText();
        if (secondaryText != null && secondaryText.length() > 0) {
            return this.getPrimaryText() + " (" + secondaryText + ")";
        }
        return this.getPrimaryText();
    }

    public void setCommentAttributes(SimpleTextAttributes commentAttributes) {
        this.myCommentAttributes = commentAttributes;
    }

    public void setTextAttributes(SimpleTextAttributes textAttributes) {
        this.myTextAttributes = textAttributes;
    }
}

