/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ComboBoxTableRenderer<T>
extends JLabel
implements TableCellRenderer,
TableCellEditor,
JBPopupListener {
    private final T[] myValues;
    private WeakReference<ListPopup> myPopupRef;
    private ChangeEvent myChangeEvent = null;
    private T myValue;
    private boolean myPaintArrow = true;
    protected EventListenerList myListenerList = new EventListenerList();
    private Runnable myFinalRunnable;

    public ComboBoxTableRenderer(T[] values) {
        this.myValues = values;
        this.setFont(UIUtil.getButtonFont());
        this.setBorder(new EmptyBorder(0, 5, 0, 5));
    }

    @Override
    public Dimension getPreferredSize() {
        return ComboBoxTableRenderer.addIconSize(super.getPreferredSize());
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private static Dimension addIconSize(Dimension d) {
        return new Dimension(d.width + AllIcons.General.ArrowDown.getIconWidth() + 2, Math.max(d.height, AllIcons.General.ArrowDown.getIconHeight()));
    }

    protected String getTextFor(@NotNull T value) {
        return value.toString();
    }

    protected Icon getIconFor(@NotNull T value) {
        return null;
    }

    public void setPaintArrow(boolean paintArrow) {
        this.myPaintArrow = paintArrow;
    }

    protected Runnable onChosen(@NotNull T value) {
        this.stopCellEditing(value);
        return () -> this.stopCellEditing(value);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!StringUtil.isEmpty((String)this.getText()) && this.myPaintArrow) {
            Rectangle r = this.getBounds();
            Insets i2 = this.getInsets();
            int x = r.width - i2.right - AllIcons.General.ArrowDown.getIconWidth();
            int y = i2.top + (r.height - i2.top - i2.bottom - AllIcons.General.ArrowDown.getIconHeight()) / 2;
            AllIcons.General.ArrowDown.paintIcon(this, g, x, y);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Object t = value;
        this.customizeComponent(t, table, isSelected);
        return this;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Object t = value;
        this.myValue = t;
        this.customizeComponent(t, table, true);
        SwingUtilities.invokeLater(() -> this.showPopup(t, row));
        return this;
    }

    protected boolean isApplicable(T value, int row) {
        return true;
    }

    private void showPopup(T value, int row) {
        List filtered = ContainerUtil.findAll((Object[])this.myValues, t -> this.isApplicable(t, row));
        ListPopup popup = JBPopupFactory.getInstance().createListPopup(new ListStep<T>(filtered, value){

            @Override
            @NotNull
            public String getTextFor(T value) {
                return ComboBoxTableRenderer.this.getTextFor(value);
            }

            @Override
            public Icon getIconFor(T value) {
                return ComboBoxTableRenderer.this.getIconFor(value);
            }

            @Override
            public PopupStep onChosen(T selectedValue, boolean finalChoice) {
                ComboBoxTableRenderer.this.myFinalRunnable = ComboBoxTableRenderer.this.onChosen(selectedValue);
                return FINAL_CHOICE;
            }

            @Override
            public void canceled() {
                ComboBoxTableRenderer.this.cancelCellEditing();
            }

            @Override
            public Runnable getFinalRunnable() {
                return ComboBoxTableRenderer.this.myFinalRunnable;
            }
        });
        popup.addListener(this);
        popup.setRequestFocus(false);
        this.myPopupRef = new WeakReference<ListPopup>(popup);
        popup.showUnderneathOf(this);
    }

    @Override
    public void beforeShown(LightweightWindowEvent event) {
    }

    @Override
    public void onClosed(LightweightWindowEvent event) {
        event.asPopup().removeListener(this);
        this.fireEditingCanceled();
    }

    protected void customizeComponent(T value, JTable table, boolean isSelected) {
        this.setOpaque(true);
        this.setText(value == null ? "" : this.getTextFor(value));
        if (value != null) {
            this.setIcon(this.getIconFor(value));
        }
        this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
    }

    @Override
    public Object getCellEditorValue() {
        return this.myValue;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        if (event instanceof MouseEvent) {
            return ((MouseEvent)event).getClickCount() >= 2;
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    private void stopCellEditing(T value) {
        this.myValue = value;
        this.stopCellEditing();
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        this.hidePopup();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
        this.hidePopup();
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.myListenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != CellEditorListener.class) continue;
            if (this.myChangeEvent == null) {
                this.myChangeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i2 + 1]).editingStopped(this.myChangeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.myListenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != CellEditorListener.class) continue;
            if (this.myChangeEvent == null) {
                this.myChangeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)listeners[i2 + 1]).editingCanceled(this.myChangeEvent);
        }
    }

    private void hidePopup() {
        if (this.myPopupRef != null) {
            ListPopup popup = (ListPopup)this.myPopupRef.get();
            if (popup != null && popup.isVisible()) {
                popup.cancel();
            }
            this.myPopupRef = null;
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.myListenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.myListenerList.remove(CellEditorListener.class, l);
    }

    private static abstract class ListStep<T>
    implements ListPopupStep<T> {
        private final List<T> myValues;
        private final T mySelected;

        protected ListStep(List<T> values, T selected) {
            this.myValues = values;
            this.mySelected = selected;
        }

        @Override
        public String getTitle() {
            return null;
        }

        @Override
        public boolean hasSubstep(T selectedValue) {
            return false;
        }

        @Override
        public boolean isMnemonicsNavigationEnabled() {
            return false;
        }

        @Override
        public boolean isSpeedSearchEnabled() {
            return false;
        }

        @Override
        public boolean isAutoSelectionEnabled() {
            return false;
        }

        @Override
        @NotNull
        public List<T> getValues() {
            return this.myValues;
        }

        @Override
        public boolean isSelectable(T value) {
            return true;
        }

        @Override
        public Icon getIconFor(T aValue) {
            return null;
        }

        @Override
        public ListSeparator getSeparatorAbove(T value) {
            return null;
        }

        @Override
        public int getDefaultOptionIndex() {
            return this.mySelected == null ? 0 : this.myValues.indexOf(this.mySelected);
        }

        @Override
        public MnemonicNavigationFilter<T> getMnemonicNavigationFilter() {
            return null;
        }

        @Override
        public SpeedSearchFilter<T> getSpeedSearchFilter() {
            return null;
        }
    }
}

