/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.popup;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopupChooserBuilder {
    private JComponent myChooserComponent;
    private String myTitle;
    private final ArrayList<KeyStroke> myAdditionalKeystrokes = new ArrayList();
    private Runnable myItemChosenRunnable;
    private JComponent mySouthComponent;
    private JComponent myEastComponent;
    private JBPopup myPopup;
    private boolean myRequestFocus = true;
    private boolean myForceResizable = false;
    private boolean myForceMovable = false;
    private String myDimensionServiceKey = null;
    private Computable<Boolean> myCancelCallback;
    private boolean myAutoselect = true;
    private float myAlpha;
    private Component[] myFocusOwners = new Component[0];
    private boolean myCancelKeyEnabled = true;
    private final List<JBPopupListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private String myAd;
    private Dimension myMinSize;
    private ActiveComponent myCommandButton;
    private final List<Pair<ActionListener, KeyStroke>> myKeyboardActions = new ArrayList<Pair<ActionListener, KeyStroke>>();
    private Component mySettingsButtons;
    private boolean myAutoselectOnMouseMove = true;
    private Function<Object, String> myItemsNamer = null;
    private boolean myMayBeParent;
    private int myAdAlignment = 2;
    private boolean myModalContext;
    private boolean myCloseOnEnter = true;
    private boolean myCancelOnWindowDeactivation = true;
    private boolean myUseForXYLocation;
    @Nullable
    private Processor<JBPopup> myCouldPin;
    private boolean myCancelOnClickOutside = true;
    private JScrollPane myScrollPane;

    public PopupChooserBuilder setCancelOnClickOutside(boolean cancelOnClickOutside) {
        this.myCancelOnClickOutside = cancelOnClickOutside;
        return this;
    }

    public JScrollPane getScrollPane() {
        return this.myScrollPane;
    }

    public PopupChooserBuilder(@NotNull JList list) {
        this.myChooserComponent = list;
    }

    public PopupChooserBuilder(@NotNull JTable table) {
        this.myChooserComponent = table;
    }

    public PopupChooserBuilder(@NotNull JTree tree) {
        this.myChooserComponent = tree;
    }

    @NotNull
    public PopupChooserBuilder setTitle(@NotNull @Nls String title) {
        this.myTitle = title;
        return this;
    }

    @NotNull
    public PopupChooserBuilder addAdditionalChooseKeystroke(@Nullable KeyStroke keyStroke) {
        if (keyStroke != null) {
            this.myAdditionalKeystrokes.add(keyStroke);
        }
        return this;
    }

    @NotNull
    public PopupChooserBuilder setItemChoosenCallback(@NotNull Runnable runnable) {
        this.myItemChosenRunnable = runnable;
        return this;
    }

    @NotNull
    public PopupChooserBuilder setSouthComponent(@NotNull JComponent cmp) {
        this.mySouthComponent = cmp;
        return this;
    }

    @NotNull
    public PopupChooserBuilder setCouldPin(@Nullable Processor<JBPopup> callback) {
        this.myCouldPin = callback;
        return this;
    }

    @NotNull
    public PopupChooserBuilder setEastComponent(@NotNull JComponent cmp) {
        this.myEastComponent = cmp;
        return this;
    }

    public PopupChooserBuilder setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
        return this;
    }

    public PopupChooserBuilder setResizable(boolean forceResizable) {
        this.myForceResizable = forceResizable;
        return this;
    }

    public PopupChooserBuilder setMovable(boolean forceMovable) {
        this.myForceMovable = forceMovable;
        return this;
    }

    public PopupChooserBuilder setDimensionServiceKey(@NonNls String key) {
        this.myDimensionServiceKey = key;
        return this;
    }

    public PopupChooserBuilder setUseDimensionServiceForXYLocation(boolean use) {
        this.myUseForXYLocation = use;
        return this;
    }

    public PopupChooserBuilder setCancelCallback(Computable<Boolean> callback) {
        this.myCancelCallback = callback;
        return this;
    }

    public PopupChooserBuilder setCommandButton(@NotNull ActiveComponent commandButton) {
        this.myCommandButton = commandButton;
        return this;
    }

    public PopupChooserBuilder setAlpha(float alpha) {
        this.myAlpha = alpha;
        return this;
    }

    public PopupChooserBuilder setAutoselectOnMouseMove(boolean doAutoSelect) {
        this.myAutoselectOnMouseMove = doAutoSelect;
        return this;
    }

    public PopupChooserBuilder setFilteringEnabled(Function<Object, String> namer) {
        this.myItemsNamer = namer;
        return this;
    }

    public PopupChooserBuilder setModalContext(boolean modalContext) {
        this.myModalContext = modalContext;
        return this;
    }

    @NotNull
    public JBPopup createPopup() {
        JList list;
        BooleanFunction keyEventHandler = null;
        if (this.myChooserComponent instanceof JList) {
            list = (JList)this.myChooserComponent;
            this.myChooserComponent = ListWithFilter.wrap(list, new MyListWrapper(list), this.myItemsNamer);
            keyEventHandler = keyEvent -> keyEvent.isConsumed();
        } else {
            list = null;
        }
        JPanel contentPane = new JPanel(new BorderLayout());
        if (!this.myForceMovable && this.myTitle != null) {
            JLabel label = new JLabel(this.myTitle);
            label.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            label.setHorizontalAlignment(0);
            contentPane.add((Component)label, "North");
        }
        if (list != null && list.getSelectedIndex() == -1 && this.myAutoselect) {
            list.setSelectedIndex(0);
        }
        (list != null ? list : this.myChooserComponent).addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (UIUtil.isActionClick((MouseEvent)e, (int)502) && !UIUtil.isSelectionButtonDown((MouseEvent)e) && !e.isConsumed()) {
                    if (PopupChooserBuilder.this.myCloseOnEnter) {
                        PopupChooserBuilder.this.closePopup(true, e, true);
                    } else {
                        PopupChooserBuilder.this.myItemChosenRunnable.run();
                    }
                }
            }
        });
        this.registerClosePopupKeyboardAction(KeyStroke.getKeyStroke(27, 0), false);
        if (this.myCloseOnEnter) {
            this.registerClosePopupKeyboardAction(KeyStroke.getKeyStroke(10, 0), true);
        } else {
            this.registerKeyboardAction(KeyStroke.getKeyStroke(10, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    PopupChooserBuilder.this.myItemChosenRunnable.run();
                }
            });
        }
        for (KeyStroke keystroke : this.myAdditionalKeystrokes) {
            this.registerClosePopupKeyboardAction(keystroke, true);
        }
        if (this.myChooserComponent instanceof ListWithFilter) {
            this.myScrollPane = ((ListWithFilter)this.myChooserComponent).getScrollPane();
        } else if (this.myChooserComponent instanceof JTable) {
            this.myScrollPane = this.createScrollPane((JTable)this.myChooserComponent);
        } else if (this.myChooserComponent instanceof JTree) {
            this.myScrollPane = this.createScrollPane((JTree)this.myChooserComponent);
        } else {
            throw new IllegalStateException("PopupChooserBuilder is intended to be constructed with one of JTable, JTree, JList components");
        }
        this.myScrollPane.getViewport().setCursor(Cursor.getPredefinedCursor(12));
        Insets viewportPadding = UIUtil.getListViewportPadding();
        ((JComponent)this.myScrollPane.getViewport().getView()).setBorder(BorderFactory.createEmptyBorder(viewportPadding.top, viewportPadding.left, viewportPadding.bottom, viewportPadding.right));
        if (this.myChooserComponent instanceof ListWithFilter) {
            this.addCenterComponentToContentPane(contentPane, this.myChooserComponent);
        } else {
            this.addCenterComponentToContentPane(contentPane, this.myScrollPane);
        }
        if (this.mySouthComponent != null) {
            this.addSouthComponentToContentPane(contentPane, this.mySouthComponent);
        }
        if (this.myEastComponent != null) {
            this.addEastComponentToContentPane(contentPane, this.myEastComponent);
        }
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder(contentPane, this.myChooserComponent);
        for (JBPopupListener each : this.myListeners) {
            builder.addListener(each);
        }
        builder.setDimensionServiceKey(null, this.myDimensionServiceKey, this.myUseForXYLocation).setRequestFocus(this.myRequestFocus).setResizable(this.myForceResizable).setMovable(this.myForceMovable).setTitle(this.myForceMovable ? this.myTitle : null).setCancelCallback(this.myCancelCallback).setAlpha(this.myAlpha).setFocusOwners(this.myFocusOwners).setCancelKeyEnabled(this.myCancelKeyEnabled).setAdText(this.myAd, this.myAdAlignment).setKeyboardActions(this.myKeyboardActions).setMayBeParent(this.myMayBeParent).setLocateWithinScreenBounds(true).setCancelOnOtherWindowOpen(true).setModalContext(this.myModalContext).setCancelOnWindowDeactivation(this.myCancelOnWindowDeactivation).setCancelOnClickOutside(this.myCancelOnClickOutside).setCouldPin(this.myCouldPin);
        if (keyEventHandler != null) {
            builder.setKeyEventHandler((BooleanFunction<KeyEvent>)keyEventHandler);
        }
        if (this.myCommandButton != null) {
            builder.setCommandButton(this.myCommandButton);
        }
        if (this.myMinSize != null) {
            builder.setMinSize(this.myMinSize);
        }
        if (this.mySettingsButtons != null) {
            builder.setSettingButtons(this.mySettingsButtons);
        }
        this.myPopup = builder.createPopup();
        return this.myPopup;
    }

    protected void addEastComponentToContentPane(JPanel contentPane, JComponent component) {
        contentPane.add((Component)component, "East");
    }

    protected void addSouthComponentToContentPane(JPanel contentPane, JComponent component) {
        contentPane.add((Component)component, "South");
    }

    protected void addCenterComponentToContentPane(JPanel contentPane, JComponent component) {
        contentPane.add((Component)component, "Center");
    }

    public PopupChooserBuilder setMinSize(Dimension dimension) {
        this.myMinSize = dimension;
        return this;
    }

    public PopupChooserBuilder registerKeyboardAction(KeyStroke keyStroke, ActionListener actionListener) {
        this.myKeyboardActions.add((Pair<ActionListener, KeyStroke>)Pair.create((Object)actionListener, (Object)keyStroke));
        return this;
    }

    private void registerClosePopupKeyboardAction(KeyStroke keyStroke, final boolean shouldPerformAction) {
        this.registerPopupKeyboardAction(keyStroke, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!shouldPerformAction && PopupChooserBuilder.this.myChooserComponent instanceof ListWithFilter && ((ListWithFilter)PopupChooserBuilder.this.myChooserComponent).resetFilter()) {
                    return;
                }
                PopupChooserBuilder.this.closePopup(shouldPerformAction, null, shouldPerformAction);
            }
        });
    }

    private void registerPopupKeyboardAction(KeyStroke keyStroke, AbstractAction action) {
        this.myChooserComponent.registerKeyboardAction(action, keyStroke, 1);
    }

    private void closePopup(boolean shouldPerformAction, MouseEvent e, boolean isOk) {
        if (shouldPerformAction) {
            this.myPopup.setFinalRunnable(this.myItemChosenRunnable);
        }
        if (isOk) {
            this.myPopup.closeOk(e);
        } else {
            this.myPopup.cancel(e);
        }
    }

    @NotNull
    private JScrollPane createScrollPane(final JTable table) {
        if (table instanceof TreeTable) {
            TreeUtil.expandAll(((TreeTable)table).getTree());
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(table);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (table.getSelectedRow() == -1) {
            table.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (table.getRowCount() >= 20) {
            scrollPane.getViewport().setPreferredSize(new Dimension(table.getPreferredScrollableViewportSize().width, 300));
        } else {
            scrollPane.getViewport().setPreferredSize(table.getPreferredSize());
        }
        if (this.myAutoselectOnMouseMove) {
            table.addMouseMotionListener(new MouseMotionAdapter(){
                boolean myIsEngaged = false;

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (this.myIsEngaged) {
                        int index = table.rowAtPoint(e.getPoint());
                        table.getSelectionModel().setSelectionInterval(index, index);
                    } else {
                        this.myIsEngaged = true;
                    }
                }
            });
        }
        return scrollPane;
    }

    @NotNull
    private JScrollPane createScrollPane(final JTree tree) {
        TreeUtil.expandAll(tree);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(tree);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (tree.getSelectionCount() == 0) {
            tree.setSelectionRow(0);
        }
        if (tree.getRowCount() >= 20) {
            scrollPane.getViewport().setPreferredSize(new Dimension(tree.getPreferredScrollableViewportSize().width, 300));
        } else {
            scrollPane.getViewport().setPreferredSize(tree.getPreferredSize());
        }
        if (this.myAutoselectOnMouseMove) {
            tree.addMouseMotionListener(new MouseMotionAdapter(){
                boolean myIsEngaged = false;

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (this.myIsEngaged) {
                        Point p = e.getPoint();
                        int index = tree.getRowForLocation(p.x, p.y);
                        tree.setSelectionRow(index);
                    } else {
                        this.myIsEngaged = true;
                    }
                }
            });
        }
        return scrollPane;
    }

    public PopupChooserBuilder setAutoSelectIfEmpty(boolean autoselect) {
        this.myAutoselect = autoselect;
        return this;
    }

    public PopupChooserBuilder setCancelKeyEnabled(boolean enabled) {
        this.myCancelKeyEnabled = enabled;
        return this;
    }

    public PopupChooserBuilder addListener(JBPopupListener listener) {
        this.myListeners.add(listener);
        return this;
    }

    public PopupChooserBuilder setSettingButton(Component abutton) {
        this.mySettingsButtons = abutton;
        return this;
    }

    public PopupChooserBuilder setMayBeParent(boolean mayBeParent) {
        this.myMayBeParent = mayBeParent;
        return this;
    }

    public PopupChooserBuilder setCloseOnEnter(boolean closeOnEnter) {
        this.myCloseOnEnter = closeOnEnter;
        return this;
    }

    @NotNull
    public PopupChooserBuilder setFocusOwners(@NotNull Component[] focusOwners) {
        this.myFocusOwners = focusOwners;
        return this;
    }

    @NotNull
    public PopupChooserBuilder setAdText(String ad) {
        this.setAdText(ad, 2);
        return this;
    }

    public PopupChooserBuilder setAdText(String ad, int alignment) {
        this.myAd = ad;
        this.myAdAlignment = alignment;
        return this;
    }

    public PopupChooserBuilder setCancelOnWindowDeactivation(boolean cancelOnWindowDeactivation) {
        this.myCancelOnWindowDeactivation = cancelOnWindowDeactivation;
        return this;
    }

    private class MyListWrapper
    extends JBScrollPane
    implements DataProvider {
        private final JList myList;

        private MyListWrapper(JList list) {
            super(UIUtil.isUnderAquaLookAndFeel() ? 0 : -1);
            list.setVisibleRowCount(15);
            this.setViewportView(list);
            if (PopupChooserBuilder.this.myAutoselectOnMouseMove) {
                ListUtil.installAutoSelectOnMouseMove(list);
            }
            ScrollingUtil.installActions(list);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.myList = list;
        }

        @Override
        @Nullable
        public Object getData(@NonNls String dataId) {
            if (PlatformDataKeys.SELECTED_ITEM.is(dataId)) {
                return this.myList.getSelectedValue();
            }
            if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
                return this.myList.getSelectedValues();
            }
            return null;
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.isPreferredSizeSet()) {
                return super.getPreferredSize();
            }
            Dimension size = this.myList.getPreferredSize();
            size.height = Math.min(size.height, this.myList.getPreferredScrollableViewportSize().height);
            JScrollBar bar = this.getVerticalScrollBar();
            if (bar != null) {
                size.width += bar.getPreferredSize().width;
            }
            return size;
        }

        @Override
        public void setBorder(Border border) {
            if (this.myList != null) {
                this.myList.setBorder(border);
            }
        }

        @Override
        public void requestFocus() {
            this.myList.requestFocus();
        }

        @Override
        public synchronized void addMouseListener(MouseListener l) {
            this.myList.addMouseListener(l);
        }
    }
}

