/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncResult<T>
extends ActionCallback {
    private static final Logger LOG = Logger.getInstance(AsyncResult.class);
    protected T myResult;

    public AsyncResult() {
    }

    AsyncResult(int countToDone, @Nullable T result) {
        super(countToDone);
        this.myResult = result;
    }

    @NotNull
    public AsyncResult<T> setDone(T result) {
        this.myResult = result;
        this.setDone();
        return this;
    }

    @NotNull
    public AsyncResult<T> setRejected(T result) {
        this.myResult = result;
        this.setRejected();
        return this;
    }

    @NotNull
    public <DependentResult> AsyncResult<DependentResult> subResult(@NotNull Function<T, DependentResult> doneHandler) {
        return this.subResult(new AsyncResult<T>(), doneHandler);
    }

    @NotNull
    public <SubResult, SubAsyncResult extends AsyncResult<SubResult>> SubAsyncResult subResult(@NotNull SubAsyncResult subResult, @NotNull Function<T, SubResult> doneHandler) {
        this.doWhenDone(new SubResultDoneCallback<T, SubResult, SubAsyncResult>(subResult, doneHandler)).notifyWhenRejected(subResult);
        return subResult;
    }

    @Deprecated
    @NotNull
    public AsyncResult<T> doWhenDone(@NotNull Handler<T> handler) {
        this.doWhenDone(() -> handler.run(this.myResult));
        return this;
    }

    @NotNull
    public AsyncResult<T> doWhenDone(@NotNull Consumer<T> consumer) {
        this.doWhenDone(() -> consumer.consume(this.myResult));
        return this;
    }

    @NotNull
    public AsyncResult<T> doWhenRejected(@NotNull PairConsumer<T, String> consumer) {
        this.doWhenRejected(() -> consumer.consume(this.myResult, (Object)this.myError));
        return this;
    }

    @Override
    @NotNull
    public final AsyncResult<T> notify(@NotNull ActionCallback child) {
        super.notify(child);
        return this;
    }

    public T getResult() {
        return this.myResult;
    }

    public T getResultSync() {
        return this.getResultSync(-1L);
    }

    @Nullable
    public T getResultSync(long msTimeout) {
        this.waitFor(msTimeout);
        return this.myResult;
    }

    @NotNull
    public final ActionCallback doWhenProcessed(@NotNull Consumer<T> consumer) {
        this.doWhenDone(consumer);
        this.doWhenRejected((result, error) -> consumer.consume(result));
        return this;
    }

    @Deprecated
    @NotNull
    public static <R> AsyncResult<R> rejected() {
        return new Rejected();
    }

    @Deprecated
    @NotNull
    public static <R> AsyncResult<R> rejected(@NotNull String errorMessage) {
        AsyncResult result = new AsyncResult();
        result.reject(errorMessage);
        return result;
    }

    @NotNull
    public static <R> AsyncResult<R> done(@Nullable R result) {
        return new AsyncResult<R>().setDone(result);
    }

    private static class SubResultDoneCallback<Result, SubResult, AsyncSubResult extends AsyncResult<SubResult>>
    implements Consumer<Result> {
        private final AsyncSubResult subResult;
        private final Function<Result, SubResult> doneHandler;

        public SubResultDoneCallback(AsyncSubResult subResult, Function<Result, SubResult> doneHandler) {
            this.subResult = subResult;
            this.doneHandler = doneHandler;
        }

        public void consume(Result result) {
            Object v;
            try {
                v = this.doneHandler.fun(result);
            }
            catch (Throwable e) {
                ((ActionCallback)this.subResult).reject(e.getMessage());
                LOG.error(e);
                return;
            }
            ((AsyncResult)this.subResult).setDone((Object)v);
        }
    }

    @Deprecated
    public static class Rejected<T>
    extends AsyncResult<T> {
        public Rejected() {
            this.setRejected();
        }

        public Rejected(T value) {
            this.setRejected(value);
        }
    }

    @Deprecated
    public static class Done<T>
    extends AsyncResult<T> {
        public Done(T value) {
            this.setDone(value);
        }
    }

    @Deprecated
    public static interface Handler<T> {
        public void run(T var1);
    }
}

