/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.KeyedExtensionCollector;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassExtension<T>
extends KeyedExtensionCollector<T, Class> {
    public ClassExtension(@NonNls String epName) {
        super(epName);
    }

    @Override
    @NotNull
    protected String keyToString(@NotNull Class key) {
        return key.getName();
    }

    @Override
    @NotNull
    protected List<T> buildExtensions(@NotNull String key, @NotNull Class classKey) {
        THashSet allSupers = new THashSet();
        ClassExtension.collectSupers(classKey, (Set<String>)allSupers);
        return this.buildExtensions((Set<String>)allSupers);
    }

    private static void collectSupers(@NotNull Class classKey, @NotNull Set<String> allSupers) {
        Class<?>[] interfaces;
        allSupers.add(classKey.getName());
        for (Class<?> anInterface : interfaces = classKey.getInterfaces()) {
            ClassExtension.collectSupers(anInterface, allSupers);
        }
        Class superClass = classKey.getSuperclass();
        if (superClass != null) {
            ClassExtension.collectSupers(superClass, allSupers);
        }
    }

    @Nullable
    public T forClass(@NotNull Class t) {
        List ts = this.forKey(t);
        return ts.isEmpty() ? null : (T)ts.get(0);
    }
}

