/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.vcs.FileStatus;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStatusFactory {
    private static final FileStatusFactory ourInstance = new FileStatusFactory();
    private final List<FileStatus> myStatuses = new ArrayList<FileStatus>();

    private FileStatusFactory() {
    }

    public synchronized FileStatus createFileStatus(@NonNls @NotNull String id, @NotNull String description) {
        return this.createFileStatus(id, description, null);
    }

    public synchronized FileStatus createFileStatus(@NonNls @NotNull String id, @NotNull String description, @Nullable Color color) {
        FileStatusImpl result = new FileStatusImpl(id, ColorKey.createColorKey("FILESTATUS_" + id, color), description);
        this.myStatuses.add(result);
        return result;
    }

    public synchronized FileStatus[] getAllFileStatuses() {
        return this.myStatuses.toArray(new FileStatus[this.myStatuses.size()]);
    }

    public static FileStatusFactory getInstance() {
        return ourInstance;
    }

    private static class FileStatusImpl
    implements FileStatus {
        private final String myStatus;
        private final ColorKey myColorKey;
        private final String myText;

        public FileStatusImpl(@NotNull String status, @NotNull ColorKey key, String text) {
            this.myStatus = status;
            this.myColorKey = key;
            this.myText = text;
        }

        public String toString() {
            return this.myStatus;
        }

        @Override
        public String getText() {
            return this.myText;
        }

        @Override
        public Color getColor() {
            return EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getColor(this.getColorKey());
        }

        @Override
        @NotNull
        public ColorKey getColorKey() {
            return this.myColorKey;
        }

        @Override
        @NotNull
        public String getId() {
            return this.myStatus;
        }
    }
}

