/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.VirtualFileFilter;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListener;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.messages.Topic;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectLevelVcsManager {
    public static final Topic<VcsListener> VCS_CONFIGURATION_CHANGED = Topic.create((String)"VCS configuration changed", VcsListener.class);
    public static final Topic<VcsListener> VCS_CONFIGURATION_CHANGED_IN_PLUGIN = Topic.create((String)"VCS configuration changed in VCS plugin", VcsListener.class);

    public abstract void iterateVfUnderVcsRoot(VirtualFile var1, Processor<VirtualFile> var2);

    public static ProjectLevelVcsManager getInstance(Project project) {
        return PeriodicalTasksCloser.getInstance().safeGetComponent(project, ProjectLevelVcsManager.class);
    }

    public static ProjectLevelVcsManager getInstanceChecked(final Project project) {
        return ApplicationManager.getApplication().runReadAction(new Computable<ProjectLevelVcsManager>(){

            public ProjectLevelVcsManager compute() {
                if (project.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return ProjectLevelVcsManager.getInstance(project);
            }
        });
    }

    public abstract VcsDescriptor[] getAllVcss();

    @Nullable
    public abstract AbstractVcs findVcsByName(@NonNls String var1);

    @Nullable
    public abstract VcsDescriptor getDescriptor(String var1);

    public abstract boolean checkAllFilesAreUnder(AbstractVcs var1, VirtualFile[] var2);

    @Nullable
    public abstract AbstractVcs getVcsFor(@NotNull VirtualFile var1);

    @Nullable
    public abstract AbstractVcs getVcsFor(FilePath var1);

    @Nullable
    public abstract VirtualFile getVcsRootFor(@Nullable VirtualFile var1);

    @Nullable
    public abstract VirtualFile getVcsRootFor(FilePath var1);

    @Nullable
    public abstract VcsRoot getVcsRootObjectFor(VirtualFile var1);

    @Nullable
    public abstract VcsRoot getVcsRootObjectFor(FilePath var1);

    public abstract boolean checkVcsIsActive(AbstractVcs var1);

    public abstract boolean checkVcsIsActive(@NonNls String var1);

    public abstract AbstractVcs[] getAllActiveVcss();

    public abstract boolean hasActiveVcss();

    public abstract boolean hasAnyMappings();

    @Deprecated
    public abstract void addMessageToConsoleWindow(String var1, TextAttributes var2);

    public abstract void addMessageToConsoleWindow(@Nullable String var1, @NotNull ConsoleViewContentType var2);

    @NotNull
    public abstract VcsShowSettingOption getStandardOption(@NotNull VcsConfiguration.StandardOption var1, @NotNull AbstractVcs var2);

    @NotNull
    public abstract VcsShowConfirmationOption getStandardConfirmation(@NotNull VcsConfiguration.StandardConfirmation var1, AbstractVcs var2);

    @NotNull
    public abstract VcsShowSettingOption getOrCreateCustomOption(@NotNull String var1, @NotNull AbstractVcs var2);

    public abstract void showProjectOperationInfo(UpdatedFiles var1, String var2);

    @Deprecated
    public abstract void addVcsListener(VcsListener var1);

    @Deprecated
    public abstract void removeVcsListener(VcsListener var1);

    public abstract void startBackgroundVcsOperation();

    public abstract void stopBackgroundVcsOperation();

    public abstract boolean isBackgroundVcsOperationRunning();

    public abstract List<VirtualFile> getRootsUnderVcsWithoutFiltering(AbstractVcs var1);

    public abstract VirtualFile[] getRootsUnderVcs(@NotNull AbstractVcs var1);

    public abstract List<VirtualFile> getDetailedVcsMappings(AbstractVcs var1);

    public abstract VirtualFile[] getAllVersionedRoots();

    @NotNull
    public abstract VcsRoot[] getAllVcsRoots();

    public abstract void updateActiveVcss();

    public abstract List<VcsDirectoryMapping> getDirectoryMappings();

    public abstract List<VcsDirectoryMapping> getDirectoryMappings(AbstractVcs var1);

    @Nullable
    public abstract VcsDirectoryMapping getDirectoryMappingFor(FilePath var1);

    public abstract void setDirectoryMapping(String var1, String var2);

    public abstract void setDirectoryMappings(List<VcsDirectoryMapping> var1);

    public abstract void iterateVcsRoot(VirtualFile var1, Processor<FilePath> var2);

    public abstract void iterateVcsRoot(VirtualFile var1, Processor<FilePath> var2, @Nullable VirtualFileFilter var3);

    @Nullable
    public abstract AbstractVcs findVersioningVcs(VirtualFile var1);

    public abstract CheckoutProvider.Listener getCompositeCheckoutListener();

    public abstract VcsHistoryCache getVcsHistoryCache();

    public abstract ContentRevisionCache getContentRevisionCache();

    public abstract boolean isFileInContent(VirtualFile var1);

    public abstract boolean isIgnored(VirtualFile var1);

    @NotNull
    public abstract VcsAnnotationLocalChangesListener getAnnotationLocalChangesListener();
}

