/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileAnnotation {
    private static final Logger LOG = Logger.getInstance(FileAnnotation.class);
    @NotNull
    private final Project myProject;
    private Runnable myCloser;
    private Consumer<FileAnnotation> myReloader;

    protected FileAnnotation(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public VcsKey getVcsKey() {
        return null;
    }

    @Nullable
    public VirtualFile getFile() {
        return null;
    }

    @Nullable
    public abstract String getAnnotatedContent();

    @Nullable
    public abstract VcsRevisionNumber getCurrentRevision();

    public boolean isBaseRevisionChanged(@NotNull VcsRevisionNumber number) {
        VcsRevisionNumber currentRevision = this.getCurrentRevision();
        return currentRevision != null && !currentRevision.equals(number);
    }

    public abstract void dispose();

    @NotNull
    public abstract LineAnnotationAspect[] getAspects();

    public abstract int getLineCount();

    @Nullable
    public abstract String getToolTip(int var1);

    @Nullable
    public abstract VcsRevisionNumber getLineRevisionNumber(int var1);

    @Nullable
    public abstract Date getLineDate(int var1);

    @Nullable
    public abstract List<VcsFileRevision> getRevisions();

    @Nullable
    public AnnotationSourceSwitcher getAnnotationSourceSwitcher() {
        return null;
    }

    @Nullable
    public VcsRevisionNumber originalRevision(int lineNumber) {
        return this.getLineRevisionNumber(lineNumber);
    }

    public final void close() {
        this.myCloser.run();
    }

    public final void reload(@NotNull FileAnnotation newFileAnnotation) {
        if (this.myReloader != null) {
            this.myReloader.consume((Object)newFileAnnotation);
        }
    }

    public final void setCloser(@NotNull Runnable closer) {
        this.myCloser = closer;
    }

    public final void setReloader(@Nullable Consumer<FileAnnotation> reloader) {
        this.myReloader = reloader;
    }

    @Deprecated
    public boolean revisionsNotEmpty() {
        return true;
    }

    @Nullable
    public CurrentFileRevisionProvider getCurrentFileRevisionProvider() {
        return FileAnnotation.createDefaultCurrentFileRevisionProvider(this);
    }

    @Nullable
    public PreviousFileRevisionProvider getPreviousFileRevisionProvider() {
        return FileAnnotation.createDefaultPreviousFileRevisionProvider(this);
    }

    @Nullable
    public AuthorsMappingProvider getAuthorsMappingProvider() {
        return FileAnnotation.createDefaultAuthorsMappingProvider(this);
    }

    @Nullable
    public RevisionsOrderProvider getRevisionsOrderProvider() {
        return FileAnnotation.createDefaultRevisionsOrderProvider(this);
    }

    @Nullable
    private static CurrentFileRevisionProvider createDefaultCurrentFileRevisionProvider(@NotNull FileAnnotation annotation) {
        List<VcsFileRevision> revisions = annotation.getRevisions();
        if (revisions == null) {
            return null;
        }
        HashMap map = new HashMap();
        for (VcsFileRevision revision : revisions) {
            map.put(revision.getRevisionNumber(), revision);
        }
        ArrayList lineToRevision = new ArrayList(annotation.getLineCount());
        for (int i2 = 0; i2 < annotation.getLineCount(); ++i2) {
            lineToRevision.add(map.get(annotation.getLineRevisionNumber(i2)));
        }
        return lineNumber -> {
            LOG.assertTrue(lineNumber >= 0 && lineNumber < lineToRevision.size());
            return (VcsFileRevision)lineToRevision.get(lineNumber);
        };
    }

    @Nullable
    private static PreviousFileRevisionProvider createDefaultPreviousFileRevisionProvider(@NotNull FileAnnotation annotation) {
        List<VcsFileRevision> revisions = annotation.getRevisions();
        if (revisions == null) {
            return null;
        }
        HashMap map = new HashMap();
        for (int i2 = 0; i2 < revisions.size(); ++i2) {
            VcsFileRevision revision = revisions.get(i2);
            VcsFileRevision previousRevision = i2 + 1 < revisions.size() ? revisions.get(i2 + 1) : null;
            map.put(revision.getRevisionNumber(), previousRevision);
        }
        final ArrayList lineToRevision = new ArrayList(annotation.getLineCount());
        for (int i3 = 0; i3 < annotation.getLineCount(); ++i3) {
            lineToRevision.add(map.get(annotation.getLineRevisionNumber(i3)));
        }
        final VcsFileRevision lastRevision = (VcsFileRevision)ContainerUtil.getFirstItem(revisions);
        return new PreviousFileRevisionProvider(){

            @Override
            @Nullable
            public VcsFileRevision getPreviousRevision(int lineNumber) {
                LOG.assertTrue(lineNumber >= 0 && lineNumber < lineToRevision.size());
                return (VcsFileRevision)lineToRevision.get(lineNumber);
            }

            @Override
            @Nullable
            public VcsFileRevision getLastRevision() {
                return lastRevision;
            }
        };
    }

    @Nullable
    private static AuthorsMappingProvider createDefaultAuthorsMappingProvider(@NotNull FileAnnotation annotation) {
        List<VcsFileRevision> revisions = annotation.getRevisions();
        if (revisions == null) {
            return null;
        }
        HashMap authorsMapping = new HashMap();
        for (VcsFileRevision revision : revisions) {
            String author = revision.getAuthor();
            if (author == null) continue;
            authorsMapping.put(revision.getRevisionNumber(), author);
        }
        return () -> FileAnnotation.lambda$createDefaultAuthorsMappingProvider$1((Map)authorsMapping);
    }

    @Nullable
    private static RevisionsOrderProvider createDefaultRevisionsOrderProvider(@NotNull FileAnnotation annotation) {
        List<VcsFileRevision> revisions = annotation.getRevisions();
        if (revisions == null) {
            return null;
        }
        List orderedRevisions = ContainerUtil.map(revisions, revision -> Collections.singletonList(revision.getRevisionNumber()));
        return () -> orderedRevisions;
    }

    private static /* synthetic */ Map lambda$createDefaultAuthorsMappingProvider$1(Map authorsMapping) {
        return authorsMapping;
    }

    public static interface RevisionsOrderProvider {
        @NotNull
        public List<List<VcsRevisionNumber>> getOrderedRevisions();
    }

    public static interface AuthorsMappingProvider {
        @NotNull
        public Map<VcsRevisionNumber, String> getAuthors();
    }

    public static interface PreviousFileRevisionProvider {
        @Nullable
        public VcsFileRevision getPreviousRevision(int var1);

        @Nullable
        public VcsFileRevision getLastRevision();
    }

    public static interface CurrentFileRevisionProvider {
        @Nullable
        public VcsFileRevision getRevision(int var1);
    }
}

