/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListModification;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeListManager
implements ChangeListModification {
    @NotNull
    public static ChangeListManager getInstance(Project project) {
        return PeriodicalTasksCloser.getInstance().safeGetComponent(project, ChangeListManager.class);
    }

    public abstract void scheduleUpdate();

    public abstract void scheduleUpdate(boolean var1);

    public abstract void invokeAfterUpdate(Runnable var1, InvokeAfterUpdateMode var2, String var3, ModalityState var4);

    public abstract void invokeAfterUpdate(Runnable var1, InvokeAfterUpdateMode var2, String var3, Consumer<VcsDirtyScopeManager> var4, ModalityState var5);

    public abstract boolean ensureUpToDate(boolean var1);

    public abstract int getChangeListsNumber();

    public abstract List<LocalChangeList> getChangeListsCopy();

    @NotNull
    public abstract List<LocalChangeList> getChangeLists();

    public abstract List<File> getAffectedPaths();

    @NotNull
    public abstract List<VirtualFile> getAffectedFiles();

    public abstract boolean isFileAffected(VirtualFile var1);

    @NotNull
    public abstract Collection<Change> getAllChanges();

    @Nullable
    public abstract LocalChangeList findChangeList(String var1);

    @Nullable
    public abstract LocalChangeList getChangeList(String var1);

    public abstract LocalChangeList getDefaultChangeList();

    public abstract boolean isDefaultChangeList(ChangeList var1);

    @Nullable
    public abstract LocalChangeList getChangeList(@NotNull Change var1);

    @Nullable
    public abstract String getChangeListNameIfOnlyOne(Change[] var1);

    @NotNull
    public abstract Runnable prepareForChangeDeletion(Collection<Change> var1);

    @Nullable
    public abstract Change getChange(@NotNull VirtualFile var1);

    @Nullable
    public abstract LocalChangeList getChangeList(@NotNull VirtualFile var1);

    @Nullable
    public abstract Change getChange(FilePath var1);

    public abstract boolean isUnversioned(VirtualFile var1);

    @NotNull
    public abstract FileStatus getStatus(VirtualFile var1);

    @NotNull
    public abstract Collection<Change> getChangesIn(VirtualFile var1);

    @NotNull
    public abstract Collection<Change> getChangesIn(FilePath var1);

    @Nullable
    public abstract AbstractVcs getVcsFor(@NotNull Change var1);

    public abstract void addChangeListListener(ChangeListListener var1);

    public abstract void removeChangeListListener(ChangeListListener var1);

    public abstract void registerCommitExecutor(CommitExecutor var1);

    public abstract void commitChanges(LocalChangeList var1, List<Change> var2);

    public abstract void commitChangesSynchronously(LocalChangeList var1, List<Change> var2);

    public abstract boolean commitChangesSynchronouslyWithResult(LocalChangeList var1, List<Change> var2);

    public abstract void reopenFiles(List<FilePath> var1);

    public abstract List<CommitExecutor> getRegisteredExecutors();

    public abstract void addFilesToIgnore(IgnoredFileBean ... var1);

    public abstract void addDirectoryToIgnoreImplicitly(@NotNull String var1);

    public abstract void removeImplicitlyIgnoredDirectory(@NotNull String var1);

    public abstract void setFilesToIgnore(IgnoredFileBean ... var1);

    public abstract IgnoredFileBean[] getFilesToIgnore();

    public abstract boolean isIgnoredFile(@NotNull VirtualFile var1);

    @Nullable
    public abstract String getSwitchedBranch(VirtualFile var1);

    public abstract String getDefaultListName();

    public abstract void letGo();

    public abstract String isFreezed();

    public abstract boolean isFreezedWithNotification(@Nullable String var1);

    public static boolean isFileChanged(Project project, VirtualFile vf) {
        FileStatus status = ChangeListManager.getInstance(project).getStatus(vf);
        return !FileStatus.NOT_CHANGED.equals(status) && !FileStatus.UNKNOWN.equals(status) && !FileStatus.IGNORED.equals(status);
    }

    public abstract List<VirtualFile> getModifiedWithoutEditing();

    @NotNull
    public abstract ThreeState haveChangesUnder(@NotNull VirtualFile var1);
}

