/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesUtil {
    private static final Key<Boolean> INTERNAL_OPERATION_KEY = Key.create((String)"internal vcs operation");
    public static final TObjectHashingStrategy<FilePath> FILE_PATH_BY_PATH_ONLY_HASHING_STRATEGY = new TObjectHashingStrategy<FilePath>(){

        public int computeHashCode(@NotNull FilePath path2) {
            return path2.getPath().hashCode();
        }

        public boolean equals(@NotNull FilePath path1, @NotNull FilePath path2) {
            return StringUtil.equals((CharSequence)path1.getPath(), (CharSequence)path2.getPath());
        }
    };

    private ChangesUtil() {
    }

    @NotNull
    public static FilePath getFilePath(@NotNull Change change) {
        ContentRevision revision = change.getAfterRevision();
        if (revision == null) {
            revision = change.getBeforeRevision();
            assert (revision != null);
        }
        return revision.getFile();
    }

    @Nullable
    public static FilePath getBeforePath(@NotNull Change change) {
        ContentRevision revision = change.getBeforeRevision();
        return revision == null ? null : revision.getFile();
    }

    @Nullable
    public static FilePath getAfterPath(@NotNull Change change) {
        ContentRevision revision = change.getAfterRevision();
        return revision == null ? null : revision.getFile();
    }

    @Nullable
    public static AbstractVcs getVcsForChange(@NotNull Change change, @NotNull Project project) {
        AbstractVcs result = ChangeListManager.getInstance(project).getVcsFor(change);
        return result != null ? result : ProjectLevelVcsManager.getInstance(project).getVcsFor(ChangesUtil.getFilePath(change));
    }

    @NotNull
    public static Set<AbstractVcs> getAffectedVcses(@NotNull Collection<Change> changes, @NotNull Project project) {
        return ContainerUtil.map2SetNotNull(changes, change -> ChangesUtil.getVcsForChange(change, project));
    }

    @Nullable
    public static AbstractVcs getVcsForFile(@NotNull VirtualFile file, @NotNull Project project) {
        return ProjectLevelVcsManager.getInstance(project).getVcsFor(file);
    }

    @Nullable
    public static AbstractVcs getVcsForFile(@NotNull File file, @NotNull Project project) {
        return ProjectLevelVcsManager.getInstance(project).getVcsFor(VcsUtil.getFilePath(file));
    }

    @NotNull
    public static List<FilePath> getPaths(@NotNull Collection<Change> changes) {
        THashSet distinctPaths = ChangesUtil.getAllPaths(changes.stream()).collect(Collectors.toCollection(() -> ContainerUtil.newTroveSet(FILE_PATH_BY_PATH_ONLY_HASHING_STRATEGY)));
        return ContainerUtil.newArrayList((Iterable)distinctPaths);
    }

    @NotNull
    public static List<File> getIoFilesFromChanges(@NotNull Collection<Change> changes) {
        return ChangesUtil.getAllPaths(changes.stream()).map(FilePath::getIOFile).distinct().collect(Collectors.toList());
    }

    @NotNull
    public static Stream<FilePath> getAllPaths(@NotNull Stream<Change> changes) {
        return changes.flatMap(change -> Stream.of(ChangesUtil.getBeforePath(change), ChangesUtil.getAfterPath(change)).filter(Objects::nonNull).distinct());
    }

    @NotNull
    public static Stream<VirtualFile> getAllFiles(@NotNull Stream<Change> changes) {
        return ChangesUtil.getAllPaths(changes).map(FilePath::getVirtualFile).filter(Objects::nonNull);
    }

    @Deprecated
    @NotNull
    public static VirtualFile[] getFilesFromChanges(@NotNull Collection<Change> changes) {
        return (VirtualFile[])ChangesUtil.getAllFiles(changes.stream()).toArray(VirtualFile[]::new);
    }

    @NotNull
    public static Navigatable[] getNavigatableArray(@NotNull Project project, @NotNull VirtualFile[] files) {
        return ChangesUtil.getNavigatableArray(project, Stream.of(files));
    }

    @NotNull
    public static Navigatable[] getNavigatableArray(@NotNull Project project, @NotNull Stream<VirtualFile> files) {
        return (Navigatable[])files.filter(file -> !file.isDirectory()).map(file -> new OpenFileDescriptor(project, (VirtualFile)file)).toArray(Navigatable[]::new);
    }

    @Nullable
    public static ChangeList getChangeListIfOnlyOne(@NotNull Project project, @Nullable Change[] changes) {
        ChangeListManager manager = ChangeListManager.getInstance(project);
        String changeListName = manager.getChangeListNameIfOnlyOne(changes);
        return changeListName == null ? null : manager.findChangeList(changeListName);
    }

    public static FilePath getCommittedPath(@NotNull Project project, FilePath filePath2) {
        Change change = ChangeListManager.getInstance(project).getChange(filePath2);
        if (change != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision != null && afterRevision != null && !beforeRevision.getFile().equals(afterRevision.getFile()) && afterRevision.getFile().equals(filePath2)) {
                filePath2 = beforeRevision.getFile();
            }
        }
        return filePath2;
    }

    public static FilePath getLocalPath(@NotNull Project project, FilePath filePath2) {
        Change change = (Change)ReadAction.compute(() -> {
            if (project.isDisposed()) {
                throw new ProcessCanceledException();
            }
            return ChangeListManager.getInstance(project).getChange(filePath2);
        });
        if (change != null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision != null && afterRevision != null && !beforeRevision.getFile().equals(afterRevision.getFile()) && beforeRevision.getFile().equals(filePath2)) {
                return afterRevision.getFile();
            }
        }
        return filePath2;
    }

    @Nullable
    public static VirtualFile findValidParentUnderReadAction(@NotNull FilePath path2) {
        VirtualFile file = path2.getVirtualFile();
        return file != null ? file : ChangesUtil.getValidParentUnderReadAction(path2);
    }

    @Nullable
    public static VirtualFile findValidParentAccurately(@NotNull FilePath filePath2) {
        VirtualFile result = filePath2.getVirtualFile();
        if (result == null && !ApplicationManager.getApplication().isReadAccessAllowed()) {
            result = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath2.getPath());
        }
        if (result == null) {
            result = ChangesUtil.getValidParentUnderReadAction(filePath2);
        }
        return result;
    }

    @Nullable
    private static VirtualFile getValidParentUnderReadAction(@NotNull FilePath filePath2) {
        return (VirtualFile)ReadAction.compute(() -> {
            VirtualFile result = null;
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            for (FilePath parent = filePath2; result == null && parent != null; parent = parent.getParentPath()) {
                result = lfs.findFileByPath(parent.getPath());
            }
            return result;
        });
    }

    @Nullable
    public static String getProjectRelativePath(@NotNull Project project, @Nullable File fileName) {
        if (fileName == null) {
            return null;
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return fileName.toString();
        }
        String relativePath = FileUtil.getRelativePath((File)VfsUtilCore.virtualToIoFile(baseDir), (File)fileName);
        if (relativePath != null) {
            return relativePath;
        }
        return fileName.toString();
    }

    public static boolean isBinaryContentRevision(@Nullable ContentRevision revision) {
        return revision instanceof BinaryContentRevision && !revision.getFile().isDirectory();
    }

    public static boolean isBinaryChange(@NotNull Change change) {
        return ChangesUtil.isBinaryContentRevision(change.getBeforeRevision()) || ChangesUtil.isBinaryContentRevision(change.getAfterRevision());
    }

    public static boolean isTextConflictingChange(@NotNull Change change) {
        FileStatus status = change.getFileStatus();
        return FileStatus.MERGED_WITH_CONFLICTS.equals(status) || FileStatus.MERGED_WITH_BOTH_CONFLICTS.equals(status);
    }

    public static <T> void processItemsByVcs(@NotNull Collection<T> items, @NotNull VcsSeparator<T> separator, @NotNull PerVcsProcessor<T> processor) {
        Map changesByVcs = (Map)ReadAction.compute(() -> StreamEx.of((Collection)items).mapToEntry(separator::getVcsFor, Function.identity()).nonNullKeys().grouping());
        changesByVcs.forEach(processor::process);
    }

    public static void processChangesByVcs(@NotNull Project project, @NotNull Collection<Change> changes, @NotNull PerVcsProcessor<Change> processor) {
        ChangesUtil.processItemsByVcs(changes, change -> ChangesUtil.getVcsForChange(change, project), processor);
    }

    public static void processVirtualFilesByVcs(@NotNull Project project, @NotNull Collection<VirtualFile> files, @NotNull PerVcsProcessor<VirtualFile> processor) {
        ChangesUtil.processItemsByVcs(files, file -> ChangesUtil.getVcsForFile(file, project), processor);
    }

    public static void processFilePathsByVcs(@NotNull Project project, @NotNull Collection<FilePath> files, @NotNull PerVcsProcessor<FilePath> processor) {
        ChangesUtil.processItemsByVcs(files, filePath2 -> ChangesUtil.getVcsForFile(filePath2.getIOFile(), project), processor);
    }

    @NotNull
    public static List<File> filePathsToFiles(@NotNull Collection<FilePath> filePaths) {
        return filePaths.stream().map(FilePath::getIOFile).collect(Collectors.toList());
    }

    public static boolean hasFileChanges(@NotNull Collection<Change> changes) {
        return changes.stream().map(ChangesUtil::getFilePath).anyMatch(path2 -> !path2.isDirectory());
    }

    public static void markInternalOperation(@NotNull Iterable<Change> changes, boolean set) {
        for (Change change : changes) {
            VirtualFile file = change.getVirtualFile();
            if (file == null) continue;
            ChangesUtil.markInternalOperation(file, set);
        }
    }

    public static void markInternalOperation(@NotNull VirtualFile file, boolean set) {
        file.putUserData(INTERNAL_OPERATION_KEY, set);
    }

    public static boolean isInternalOperation(@NotNull VirtualFile file) {
        return Boolean.TRUE.equals(file.getUserData(INTERNAL_OPERATION_KEY));
    }

    @Nullable
    public static File findCommonAncestor(@NotNull Collection<Change> changes) {
        File ancestor = null;
        for (Change change : changes) {
            File currentChangeAncestor = ChangesUtil.getCommonBeforeAfterAncestor(change);
            if (currentChangeAncestor == null) {
                return null;
            }
            if (ancestor == null) {
                ancestor = currentChangeAncestor;
                continue;
            }
            if ((ancestor = FileUtil.findAncestor((File)ancestor, (File)currentChangeAncestor)) != null) continue;
            return null;
        }
        return ancestor;
    }

    @Nullable
    private static File getCommonBeforeAfterAncestor(@NotNull Change change) {
        FilePath before = ChangesUtil.getBeforePath(change);
        FilePath after = ChangesUtil.getAfterPath(change);
        return before == null ? ((FilePath)ObjectUtils.assertNotNull((Object)after)).getIOFile() : (after == null ? before.getIOFile() : FileUtil.findAncestor((File)before.getIOFile(), (File)after.getIOFile()));
    }

    @FunctionalInterface
    public static interface VcsSeparator<T> {
        @Nullable
        public AbstractVcs getVcsFor(@NotNull T var1);
    }

    @FunctionalInterface
    public static interface PerVcsProcessor<T> {
        public void process(@NotNull AbstractVcs var1, @NotNull List<T> var2);
    }
}

