/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import org.jetbrains.annotations.NotNull;

public class FilePathsHelper {
    private FilePathsHelper() {
    }

    public static String convertPath(FilePath fp) {
        return FilePathsHelper.convertPath(fp.getPath());
    }

    public static String convertWithLastSeparator(FilePath fp) {
        return FilePathsHelper.convertWithLastSeparatorImpl(fp.getPath(), fp.isDirectory());
    }

    private static String convertWithLastSeparatorImpl(String initPath, boolean isDir) {
        String path2 = isDir ? (initPath.endsWith("/") || initPath.endsWith("\\") ? initPath : initPath + "/") : initPath;
        return FilePathsHelper.convertPath(path2);
    }

    public static String convertPath(String parent, String subpath) {
        String convParent = FileUtil.toSystemIndependentName((String)parent);
        String convPath = FileUtil.toSystemIndependentName((String)subpath);
        String withSlash = StringUtil.trimEnd((String)convParent, (String)"/") + "/" + StringUtil.trimStart((String)convPath, (String)"/");
        return SystemInfo.isFileSystemCaseSensitive ? withSlash : withSlash.toUpperCase();
    }

    @NotNull
    public static String convertPath(@NotNull String s) {
        String result = FileUtil.toSystemIndependentName((String)s);
        return SystemInfo.isFileSystemCaseSensitive ? result : result.toUpperCase();
    }
}

