/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsVirtualFile
extends AbstractVcsVirtualFile {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.vfs.VcsVirtualFile");
    private byte[] myContent;
    private final VcsFileRevision myFileRevision;
    private boolean myContentLoadFailed = false;
    private Charset myCharset;

    public VcsVirtualFile(@NotNull String path2, @Nullable VcsFileRevision revision, @NotNull VirtualFileSystem fileSystem) {
        super(path2, fileSystem);
        this.myFileRevision = revision;
    }

    public VcsVirtualFile(@NotNull String path2, @NotNull byte[] content, @Nullable String revision, @NotNull VirtualFileSystem fileSystem) {
        this(path2, null, fileSystem);
        this.myContent = content;
        this.setRevision(revision);
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        if (this.myContentLoadFailed || this.myProcessingBeforeContentsChange) {
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        if (this.myContent == null) {
            this.loadContent();
        }
        return this.myContent;
    }

    private void loadContent() throws IOException {
        if (this.myContent != null) {
            return;
        }
        assert (this.myFileRevision != null);
        final VcsFileSystem vcsFileSystem = (VcsFileSystem)this.getFileSystem();
        try {
            this.myFileRevision.loadContent();
            this.fireBeforeContentsChange();
            ++this.myModificationStamp;
            VcsRevisionNumber revisionNumber = this.myFileRevision.getRevisionNumber();
            if (revisionNumber instanceof ShortVcsRevisionNumber) {
                this.setRevision(((ShortVcsRevisionNumber)revisionNumber).toShortString());
            } else {
                this.setRevision(revisionNumber.asString());
            }
            this.myContent = this.myFileRevision.getContent();
            this.myCharset = new CharsetToolkit(this.myContent).guessEncoding(this.myContent.length);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    vcsFileSystem.fireContentsChanged(this, VcsVirtualFile.this, 0L);
                }
            });
        }
        catch (VcsException e) {
            this.myContentLoadFailed = true;
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    vcsFileSystem.fireBeforeFileDeletion(this, VcsVirtualFile.this);
                }
            });
            this.myContent = ArrayUtil.EMPTY_BYTE_ARRAY;
            this.setRevision("0");
            Messages.showMessageDialog(VcsBundle.message("message.text.could.not.load.virtual.file.content", this.getPresentableUrl(), e.getLocalizedMessage()), VcsBundle.message("message.title.could.not.load.content", new Object[0]), Messages.getInformationIcon());
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    vcsFileSystem.fireFileDeleted(this, VcsVirtualFile.this, VcsVirtualFile.this.getName(), VcsVirtualFile.this.getParent());
                }
            });
        }
        catch (ProcessCanceledException ex) {
            this.myContent = null;
        }
    }

    @Nullable
    public VcsFileRevision getFileRevision() {
        return this.myFileRevision;
    }

    @Override
    @NotNull
    public Charset getCharset() {
        if (this.myCharset != null) {
            return this.myCharset;
        }
        return super.getCharset();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    public String getRevision() {
        if (this.myRevision == null) {
            try {
                this.loadContent();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return this.myRevision;
    }
}

