/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsUtil
extends VfsUtilCore {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.VfsUtil");

    public static void saveText(@NotNull VirtualFile file, @NotNull String text) throws IOException {
        Charset charset = file.getCharset();
        file.setBinaryContent(text.getBytes(charset.name()));
    }

    public static void copyDirectory(Object requestor, @NotNull VirtualFile fromDir, @NotNull VirtualFile toDir, @Nullable VirtualFileFilter filter) throws IOException {
        VirtualFile[] children;
        for (VirtualFile child : children = fromDir.getChildren()) {
            if (child.is(VFileProperty.SYMLINK) || child.is(VFileProperty.SPECIAL) || filter != null && !filter.accept(child)) continue;
            if (!child.isDirectory()) {
                VfsUtil.copyFile(requestor, child, toDir);
                continue;
            }
            VirtualFile newChild = toDir.findChild(child.getName());
            if (newChild == null) {
                newChild = toDir.createChildDirectory(requestor, child.getName());
            }
            VfsUtil.copyDirectory(requestor, child, newChild, filter);
        }
    }

    public static VirtualFile copy(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir) throws IOException {
        if (file.isDirectory()) {
            VirtualFile newDir = toDir.createChildDirectory(requestor, file.getName());
            VfsUtil.copyDirectory(requestor, file, newDir, null);
            return newDir;
        }
        return VfsUtil.copyFile(requestor, file, toDir);
    }

    @NotNull
    public static VirtualFile[] getCommonAncestors(@NotNull VirtualFile[] files) {
        HashMap<VirtualFile, Object> map = new HashMap<VirtualFile, Object>();
        for (VirtualFile aFile : files) {
            Object filesSet;
            VirtualFile directory;
            VirtualFile virtualFile2 = directory = aFile.isDirectory() ? aFile : aFile.getParent();
            if (directory == null) {
                return VirtualFile.EMPTY_ARRAY;
            }
            VirtualFile[] path2 = VfsUtil.getPathComponents(directory);
            VirtualFile firstPart = path2[0];
            if (map.containsKey(firstPart)) {
                filesSet = (Set)map.get(firstPart);
            } else {
                filesSet = new THashSet();
                map.put(firstPart, filesSet);
            }
            filesSet.add(directory);
        }
        ArrayList<VirtualFile> ancestorsList = new ArrayList<VirtualFile>();
        for (Set filesSet : map.values()) {
            VirtualFile ancestor = null;
            for (VirtualFile file : filesSet) {
                if (ancestor == null) {
                    ancestor = file;
                    continue;
                }
                ancestor = VfsUtil.getCommonAncestor(ancestor, file);
            }
            ancestorsList.add(ancestor);
            filesSet.clear();
        }
        return VfsUtil.toVirtualFileArray(ancestorsList);
    }

    @Nullable
    public static VirtualFile getCommonAncestor(@NotNull Collection<? extends VirtualFile> files) {
        VirtualFile ancestor = null;
        for (VirtualFile virtualFile2 : files) {
            if (ancestor == null) {
                ancestor = virtualFile2;
                continue;
            }
            if ((ancestor = VfsUtil.getCommonAncestor(ancestor, virtualFile2)) != null) continue;
            return null;
        }
        return ancestor;
    }

    @Nullable
    public static VirtualFile findRelativeFile(@Nullable VirtualFile base, String ... path2) {
        VirtualFile file = base;
        for (String pathElement : path2) {
            if (file == null) {
                return null;
            }
            file = "..".equals(pathElement) ? file.getParent() : file.findChild(pathElement);
        }
        return file;
    }

    @Nullable
    public static VirtualFile findFileByURL(@NotNull URL url) {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        return VfsUtil.findFileByURL(url, virtualFileManager);
    }

    @Nullable
    public static VirtualFile findFileByURL(@NotNull URL url, @NotNull VirtualFileManager virtualFileManager) {
        String vfUrl = VfsUtil.convertFromUrl(url);
        return virtualFileManager.findFileByUrl(vfUrl);
    }

    @Nullable
    public static VirtualFile findFileByIoFile(@NotNull File file, boolean refreshIfNeeded) {
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile virtualFile2 = fileSystem.findFileByIoFile(file);
        if (refreshIfNeeded && (virtualFile2 == null || !virtualFile2.isValid())) {
            virtualFile2 = fileSystem.refreshAndFindFileByIoFile(file);
        }
        return virtualFile2;
    }

    public static VirtualFile copyFileRelative(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir, @NotNull String relativePath) throws IOException {
        String token;
        StringTokenizer tokenizer = new StringTokenizer(relativePath, "/");
        VirtualFile curDir = toDir;
        while (true) {
            token = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) break;
            VirtualFile childDir = curDir.findChild(token);
            if (childDir == null) {
                childDir = curDir.createChildDirectory(requestor, token);
            }
            curDir = childDir;
        }
        return VfsUtil.copyFile(requestor, file, curDir, token);
    }

    @NotNull
    public static URI toUri(@NotNull VirtualFile file) {
        String path2 = file.getPath();
        try {
            String protocol = file.getFileSystem().getProtocol();
            if (file.isInLocalFileSystem()) {
                if (SystemInfo.isWindows && path2.charAt(0) != '/') {
                    path2 = '/' + path2;
                }
                return new URI(protocol, "", path2, null, null);
            }
            if ("http".equals(protocol)) {
                return new URI("http://" + path2);
            }
            return new URI(protocol, path2, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @NotNull
    public static URI toUri(@NotNull File file) {
        String path2 = file.toURI().getPath();
        try {
            if (SystemInfo.isWindows && path2.charAt(0) != '/') {
                path2 = '/' + path2;
            }
            return new URI("file", "", path2, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nullable
    public static URI toUri(@NonNls @NotNull String uri) {
        int firstSlashIndex;
        int index = uri.indexOf("://");
        if (index < 0) {
            try {
                return new URI(uri);
            }
            catch (URISyntaxException e) {
                LOG.debug((Throwable)e);
                return null;
            }
        }
        if (SystemInfo.isWindows && uri.startsWith("file://") && uri.charAt(firstSlashIndex = index + "://".length()) != '/') {
            uri = "file:///" + uri.substring(firstSlashIndex);
        }
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            LOG.debug("uri is not fully encoded", (Throwable)e);
            try {
                int fragmentIndex = uri.lastIndexOf(35);
                String path2 = uri.substring(index + 1, fragmentIndex > 0 ? fragmentIndex : uri.length());
                String fragment = fragmentIndex > 0 ? uri.substring(fragmentIndex + 1) : null;
                return new URI(uri.substring(0, index), path2, fragment);
            }
            catch (URISyntaxException e1) {
                LOG.debug((Throwable)e1);
                return null;
            }
        }
    }

    @Nullable
    public static String getPath(@NotNull VirtualFile src, @NotNull VirtualFile dst, char separatorChar) {
        VirtualFile commonAncestor = VfsUtil.getCommonAncestor(src, dst);
        if (commonAncestor != null) {
            StringBuilder buffer = new StringBuilder();
            if (!Comparing.equal((Object)src, (Object)commonAncestor)) {
                while (!Comparing.equal((Object)src.getParent(), (Object)commonAncestor)) {
                    buffer.append("..").append(separatorChar);
                    src = src.getParent();
                }
            }
            buffer.append(VfsUtil.getRelativePath(dst, commonAncestor, separatorChar));
            return buffer.toString();
        }
        return null;
    }

    public static String getUrlForLibraryRoot(@NotNull File libraryRoot) {
        String path2 = FileUtil.toSystemIndependentName((String)libraryRoot.getAbsolutePath());
        if (FileTypeManager.getInstance().getFileTypeByFileName(libraryRoot.getName()) == FileTypes.ARCHIVE) {
            return VirtualFileManager.constructUrl(JarFileSystem.getInstance().getProtocol(), path2 + "!/");
        }
        return VirtualFileManager.constructUrl(LocalFileSystem.getInstance().getProtocol(), path2);
    }

    public static VirtualFile createChildSequent(Object requestor, @NotNull VirtualFile dir, @NotNull String prefix, @NotNull String extension) throws IOException {
        String dotExt = PathUtil.makeFileName("", extension);
        String fileName = prefix + dotExt;
        int i2 = 1;
        while (dir.findChild(fileName) != null) {
            fileName = prefix + "_" + i2 + dotExt;
            ++i2;
        }
        return dir.createChildData(requestor, fileName);
    }

    @NotNull
    public static String[] filterNames(@NotNull String[] names) {
        int filteredCount = 0;
        for (String string : names) {
            if (!VfsUtil.isBadName(string)) continue;
            ++filteredCount;
        }
        if (filteredCount == 0) {
            return names;
        }
        String[] result = ArrayUtil.newStringArray((int)(names.length - filteredCount));
        int count = 0;
        for (String string : names) {
            if (VfsUtil.isBadName(string)) continue;
            result[count++] = string;
        }
        return result;
    }

    public static boolean isBadName(String name) {
        return name == null || name.isEmpty() || "/".equals(name) || "\\".equals(name);
    }

    public static VirtualFile createDirectories(final @NotNull String directoryPath) throws IOException {
        return (VirtualFile)new WriteAction<VirtualFile>(){

            @Override
            protected void run(@NotNull Result<VirtualFile> result) throws Throwable {
                VirtualFile res = VfsUtil.createDirectoryIfMissing(directoryPath);
                result.setResult(res);
            }
        }.execute().throwException().getResultObject();
    }

    public static VirtualFile createDirectoryIfMissing(@Nullable VirtualFile parent, String relativePath) throws IOException {
        if (parent == null) {
            return VfsUtil.createDirectoryIfMissing(relativePath);
        }
        for (String each : StringUtil.split((String)relativePath, (String)"/")) {
            VirtualFile child = parent.findChild(each);
            if (child == null) {
                child = parent.createChildDirectory(LocalFileSystem.getInstance(), each);
            }
            parent = child;
        }
        return parent;
    }

    @Nullable
    public static VirtualFile createDirectoryIfMissing(@NotNull String directoryPath) throws IOException {
        String path2 = FileUtil.toSystemIndependentName((String)directoryPath);
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path2);
        if (file == null) {
            int pos = path2.lastIndexOf(47);
            if (pos < 0) {
                return null;
            }
            VirtualFile parent = VfsUtil.createDirectoryIfMissing(path2.substring(0, pos));
            if (parent == null) {
                return null;
            }
            String dirName = path2.substring(pos + 1);
            VirtualFile child = parent.findChild(dirName);
            if (child != null && child.isDirectory()) {
                return child;
            }
            return parent.createChildDirectory(LocalFileSystem.getInstance(), dirName);
        }
        return file;
    }

    @NotNull
    public static List<VirtualFile> collectChildrenRecursively(@NotNull VirtualFile root) {
        final ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        VfsUtil.visitChildrenRecursively(root, new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                result.add(file);
                return true;
            }
        });
        return result;
    }

    public static void processFileRecursivelyWithoutIgnored(final @NotNull VirtualFile root, final @NotNull Processor<VirtualFile> processor) {
        final FileTypeManager ftm = FileTypeManager.getInstance();
        VfsUtil.visitChildrenRecursively(root, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (!processor.process((Object)file)) {
                    return 3.skipTo(root);
                }
                return file.isDirectory() && ftm.isFileIgnored(file) ? SKIP_CHILDREN : CONTINUE;
            }
        });
    }

    @NotNull
    public static String getReadableUrl(@NotNull VirtualFile file) {
        String url = null;
        if (file.isInLocalFileSystem()) {
            url = file.getPresentableUrl();
        }
        if (url == null) {
            url = file.getUrl();
        }
        return url;
    }

    @Nullable
    public static VirtualFile getUserHomeDir() {
        String path2 = SystemProperties.getUserHome();
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path2));
    }

    @NotNull
    public static VirtualFile[] getChildren(@NotNull VirtualFile dir) {
        VirtualFile[] children = dir.getChildren();
        return children == null ? VirtualFile.EMPTY_ARRAY : children;
    }

    @NotNull
    public static List<VirtualFile> getChildren(@NotNull VirtualFile dir, @NotNull VirtualFileFilter filter) {
        List result = null;
        for (VirtualFile child : dir.getChildren()) {
            if (!filter.accept(child)) continue;
            if (result == null) {
                result = ContainerUtil.newSmartList();
            }
            result.add(child);
        }
        return result != null ? result : ContainerUtil.emptyList();
    }

    @Nullable
    public static String getParentDir(@Nullable String url) {
        if (url == null) {
            return null;
        }
        int index = url.lastIndexOf(47);
        return index < 0 ? null : url.substring(0, index);
    }

    @Nullable
    public static String extractFileName(@Nullable String urlOrPath) {
        if (urlOrPath == null) {
            return null;
        }
        int index = urlOrPath.lastIndexOf(47);
        return index < 0 ? null : urlOrPath.substring(index + 1);
    }

    @NotNull
    public static List<VirtualFile> markDirty(boolean recursive, boolean reloadChildren, VirtualFile ... files) {
        List list = ContainerUtil.filter((Object[])files, (Condition)Condition.NOT_NULL);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        for (VirtualFile file : list) {
            if (reloadChildren && file.isValid()) {
                file.getChildren();
            }
            if (!(file instanceof NewVirtualFile)) continue;
            if (recursive) {
                ((NewVirtualFile)file).markDirtyRecursively();
                continue;
            }
            ((NewVirtualFile)file).markDirty();
        }
        return list;
    }

    public static void markDirtyAndRefresh(boolean async, boolean recursive, boolean reloadChildren, VirtualFile ... files) {
        List<VirtualFile> list = VfsUtil.markDirty(recursive, reloadChildren, files);
        if (list.isEmpty()) {
            return;
        }
        LocalFileSystem.getInstance().refreshFiles(list, async, recursive, null);
    }

    @NotNull
    public static VirtualFile getRootFile(@NotNull VirtualFile file) {
        VirtualFile parent;
        while ((parent = file.getParent()) != null) {
            file = parent;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFromResource(@NotNull VirtualFile file, @NonNls @NotNull String resourceUrl) throws IOException {
        InputStream out = VfsUtil.class.getResourceAsStream(resourceUrl);
        if (out == null) {
            throw new FileNotFoundException(resourceUrl);
        }
        try {
            byte[] bytes = FileUtil.adaptiveLoadBytes((InputStream)out);
            file.setBinaryContent(bytes);
        }
        finally {
            out.close();
        }
    }

    public static String toIdeaUrl(@NotNull String url) {
        return VfsUtil.toIdeaUrl(url, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T processInputStream(@NotNull VirtualFile file, @NotNull Function<InputStream, T> function) {
        InputStream stream = null;
        try {
            stream = file.getInputStream();
            Object object = function.fun((Object)stream);
            return (T)object;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }
}

