/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.KeyEventProcessor;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FocusCommand
extends ActiveRunnable
implements Expirable {
    protected Component myDominationComponent;
    private Throwable myAllocation;
    private ActionCallback myCallback;
    private boolean myInvalidatesPendingFurtherRequestors = true;
    private Expirable myExpirable;
    private static long lastProcessedCommandTime = 0L;
    protected final long commandCreationTime = System.currentTimeMillis();
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.FocusCommand");
    private boolean myForced;

    public boolean isForced() {
        return this.myForced;
    }

    public void setForced(boolean forced) {
        this.myForced = forced;
    }

    protected FocusCommand() {
        this.saveAllocation();
    }

    protected FocusCommand(Component dominationComp) {
        this.myDominationComponent = dominationComp;
        this.saveAllocation();
    }

    protected FocusCommand(Object object) {
        super(object);
        this.saveAllocation();
    }

    protected FocusCommand(Object object, Component dominationComp) {
        super(object);
        this.myDominationComponent = dominationComp;
        this.saveAllocation();
    }

    protected FocusCommand(Object[] objects) {
        super(objects);
        this.saveAllocation();
    }

    protected FocusCommand(Object[] objects, Component dominationComp) {
        super(objects);
        this.myDominationComponent = dominationComp;
        this.saveAllocation();
    }

    public final ActionCallback getCallback() {
        return this.myCallback;
    }

    public final void setCallback(ActionCallback callback) {
        this.myCallback = callback;
    }

    @Override
    public boolean isExpired() {
        return this.myExpirable != null && this.myExpirable.isExpired();
    }

    public boolean canExecuteOnInactiveApp() {
        return false;
    }

    @Nullable
    public KeyEventProcessor getProcessor() {
        return null;
    }

    public boolean invalidatesRequestors() {
        return this.myInvalidatesPendingFurtherRequestors;
    }

    public FocusCommand setExpirable(Expirable expirable) {
        this.myExpirable = expirable;
        return this;
    }

    public FocusCommand setToInvalidateRequestors(boolean invalidatesPendingFurtherRequestors) {
        this.myInvalidatesPendingFurtherRequestors = invalidatesPendingFurtherRequestors;
        return this;
    }

    @Nullable
    public final Component getDominationComponent() {
        return this.myDominationComponent;
    }

    public boolean dominatesOver(FocusCommand cmd) {
        Component thisComponent = PopupUtil.getOwner(this.getDominationComponent());
        Component thatComponent = PopupUtil.getOwner(cmd.getDominationComponent());
        if (thisComponent != null && thatComponent != null) {
            return thisComponent != thatComponent && SwingUtilities.isDescendingFrom(thisComponent, thatComponent);
        }
        return false;
    }

    public final FocusCommand saveAllocation() {
        this.myAllocation = new Exception();
        return this;
    }

    public Throwable getAllocation() {
        return this.myAllocation;
    }

    public boolean canFocusChangeFrom(@Nullable Component component) {
        return true;
    }

    public String toString() {
        Object[] objects = this.getEqualityObjects();
        return "FocusCommand objectCount=" + objects.length + " objects=" + Arrays.asList(objects);
    }

    public static class ByComponent
    extends FocusCommand {
        private Component myToFocus;
        @Nullable
        private final Project myProject;
        private Throwable myAllocation;

        public ByComponent(@Nullable Component toFocus, @NotNull Throwable allocation) {
            this(toFocus, toFocus, null, allocation);
        }

        public ByComponent(@Nullable Component toFocus, @Nullable Component dominationComponent, @Nullable Project project, @NotNull Throwable allocation) {
            super(toFocus, dominationComponent);
            this.myProject = project;
            this.myAllocation = allocation;
            this.myToFocus = toFocus;
        }

        @Override
        @NotNull
        public final ActionCallback run() {
            boolean shouldLogFocuses = Registry.is((String)"ide.log.focuses");
            if (shouldLogFocuses) {
                this.myToFocus.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        if (this.isExpired()) {
                            return;
                        }
                        super.focusGained(e);
                        LOG.info("Focus gained on " + myToFocus.getClass().getName());
                        myToFocus.removeFocusListener(this);
                    }
                });
            }
            if (this.commandCreationTime > lastProcessedCommandTime) {
                if (!this.myToFocus.requestFocusInWindow()) {
                    IdeFrame frame;
                    if (shouldLogFocuses) {
                        LOG.info("We could not request focus in window on " + this.myToFocus.getClass().getName());
                        LOG.info(this.myAllocation);
                    }
                    if (ApplicationManager.getApplication().isActive() && ((frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame()) == null || this.myProject == null || this.myProject == frame.getProject())) {
                        this.myToFocus.requestFocus();
                        if (shouldLogFocuses) {
                            LOG.info("Force request focus on " + this.myToFocus.getClass().getName());
                        }
                    }
                } else if (shouldLogFocuses) {
                    LOG.info("We have successfully requested focus in window on " + this.myToFocus.getClass().getName());
                    LOG.info(this.myAllocation);
                }
                lastProcessedCommandTime = this.commandCreationTime;
            }
            this.clear();
            return ActionCallback.DONE;
        }

        private void clear() {
            this.myToFocus = null;
            this.myDominationComponent = null;
        }

        @Override
        public boolean isExpired() {
            return this.myToFocus == null;
        }

        public Component getComponent() {
            return this.myToFocus;
        }

        @Override
        public boolean canFocusChangeFrom(@Nullable Component component) {
            DialogWrapper dialog = DialogWrapper.findInstance(component);
            return dialog == null || dialog == DialogWrapper.findInstance(this.myToFocus);
        }
    }
}

