/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.artifacts;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.Comparator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArtifactManager
implements ArtifactModel {
    public static final Topic<ArtifactListener> TOPIC = Topic.create((String)"artifacts changes", ArtifactListener.class);
    public static final Comparator<Artifact> ARTIFACT_COMPARATOR = (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());

    public static ArtifactManager getInstance(@NotNull Project project) {
        return project.getComponent(ArtifactManager.class);
    }

    public abstract Artifact[] getSortedArtifacts();

    public abstract ModifiableArtifactModel createModifiableModel();

    public abstract PackagingElementResolvingContext getResolvingContext();

    @NotNull
    public abstract Artifact addArtifact(@NonNls @NotNull String var1, @NotNull ArtifactType var2, @Nullable CompositePackagingElement<?> var3);

    public abstract void addElementsToDirectory(@NotNull Artifact var1, @NotNull String var2, @NotNull Collection<? extends PackagingElement<?>> var3);

    public abstract void addElementsToDirectory(@NotNull Artifact var1, @NotNull String var2, @NotNull PackagingElement<?> var3);

    public abstract ModificationTracker getModificationTracker();
}

