/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.Key;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ObjectPattern<T, Self extends ObjectPattern<T, Self>>
implements Cloneable,
ElementPattern<T> {
    private InitialPatternCondition<T> myInitialCondition;
    private Object myConditions;

    protected ObjectPattern(@NotNull InitialPatternCondition<T> condition) {
        this.myInitialCondition = condition;
        this.myConditions = null;
    }

    protected ObjectPattern(final Class<T> aClass) {
        this(new InitialPatternCondition<T>(aClass){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return aClass.isInstance(o);
            }
        });
    }

    @Override
    public final boolean accepts(@Nullable Object t) {
        return this.accepts(t, new ProcessingContext());
    }

    @Override
    public boolean accepts(@Nullable Object o, ProcessingContext context) {
        if (!this.myInitialCondition.accepts(o, context)) {
            return false;
        }
        if (this.myConditions == null) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.myConditions instanceof PatternCondition) {
            return ((PatternCondition)this.myConditions).accepts(o, context);
        }
        List list = (List)this.myConditions;
        int listSize = list.size();
        for (int i2 = 0; i2 < listSize; ++i2) {
            if (((PatternCondition)list.get(i2)).accepts(o, context)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public final ElementPatternCondition<T> getCondition() {
        if (this.myConditions == null) {
            return new ElementPatternCondition<T>(this.myInitialCondition);
        }
        if (this.myConditions instanceof PatternCondition) {
            PatternCondition singleCondition = (PatternCondition)this.myConditions;
            return new ElementPatternCondition(this.myInitialCondition, Collections.singletonList(singleCondition));
        }
        return new ElementPatternCondition<T>(this.myInitialCondition, (List)this.myConditions);
    }

    @NotNull
    public Self andNot(ElementPattern pattern) {
        Capture not = StandardPatterns.not(pattern);
        return this.and(not);
    }

    @NotNull
    public Self andOr(ElementPattern ... patterns) {
        ElementPattern or = StandardPatterns.or(patterns);
        return this.and(or);
    }

    @NotNull
    public Self and(ElementPattern pattern) {
        return this.with(new PatternConditionPlus<T, T>("and", pattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<T, ProcessingContext> processor) {
                return processor.process(t, (Object)context);
            }
        });
    }

    @NotNull
    public Self equalTo(final @NotNull T o) {
        return this.with(new ValuePatternCondition<T>("equalTo"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                return t.equals(o);
            }

            @Override
            public Collection<T> getValues() {
                return Collections.singletonList(o);
            }
        });
    }

    @NotNull
    public Self oneOf(T ... values) {
        int length = values.length;
        final Collection<T> list = length == 1 ? Collections.singletonList(values[0]) : (length >= 11 ? new HashSet<T>(Arrays.asList(values)) : Arrays.asList(values));
        return this.with(new ValuePatternCondition<T>("oneOf"){

            @Override
            public Collection<T> getValues() {
                return list;
            }

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                return list.contains(t);
            }
        });
    }

    @NotNull
    public Self oneOf(final Collection<T> set) {
        return this.with(new ValuePatternCondition<T>("oneOf"){

            @Override
            public Collection<T> getValues() {
                return set;
            }

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                return set.contains(t);
            }
        });
    }

    @NotNull
    public Self isNull() {
        return this.adapt(new ElementPatternCondition(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o == null;
            }
        }));
    }

    @NotNull
    public Self notNull() {
        return this.adapt(new ElementPatternCondition(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o != null;
            }
        }));
    }

    @NotNull
    public Self save(final Key<? super T> key) {
        return this.with(new PatternCondition<T>("save"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                context.put(key, t);
                return true;
            }
        });
    }

    @NotNull
    public Self save(final @NonNls String key) {
        return this.with(new PatternCondition<T>("save"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                context.put((Object)key, t);
                return true;
            }
        });
    }

    @NotNull
    public Self with(PatternCondition<? super T> pattern) {
        ElementPatternCondition<? super T> condition = this.getCondition().append(pattern);
        return this.adapt(condition);
    }

    @NotNull
    private Self adapt(ElementPatternCondition<T> condition) {
        try {
            ObjectPattern s = (ObjectPattern)this.clone();
            s.myInitialCondition = condition.getInitialCondition();
            List<PatternCondition<T>> conditions = condition.getConditions();
            s.myConditions = conditions.isEmpty() ? null : (conditions.size() == 1 ? conditions.get(0) : conditions);
            return (Self)s;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public Self without(final PatternCondition<? super T> pattern) {
        return this.with(new PatternCondition<T>("without"){

            @Override
            public boolean accepts(@NotNull T o, ProcessingContext context) {
                return !pattern.accepts(o, context);
            }
        });
    }

    public String toString() {
        return this.getCondition().toString();
    }

    public static class Capture<T>
    extends ObjectPattern<T, Capture<T>> {
        public Capture(Class<T> aClass) {
            super(aClass);
        }

        public Capture(@NotNull InitialPatternCondition<T> condition) {
            super(condition);
        }
    }
}

