/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiNameValuePairPattern
extends PsiElementPattern<PsiNameValuePair, PsiNameValuePairPattern> {
    static final PsiNameValuePairPattern NAME_VALUE_PAIR_PATTERN = new PsiNameValuePairPattern();

    private PsiNameValuePairPattern() {
        super(PsiNameValuePair.class);
    }

    @Override
    @NotNull
    public PsiNameValuePairPattern withName(final @NotNull @NonNls String requiredName) {
        return (PsiNameValuePairPattern)this.with(new PatternCondition<PsiNameValuePair>("withName"){

            @Override
            public boolean accepts(@NotNull PsiNameValuePair psiNameValuePair, ProcessingContext context) {
                String actualName = psiNameValuePair.getName();
                return requiredName.equals(actualName) || actualName == null && "value".equals(requiredName);
            }
        });
    }

    @Override
    @NotNull
    public PsiNameValuePairPattern withName(@NotNull ElementPattern<String> name) {
        return (PsiNameValuePairPattern)this.with(new PsiNamePatternCondition<PsiNameValuePair>("withName", name){

            @Override
            public String getPropertyValue(@NotNull Object o) {
                if (o instanceof PsiNameValuePair) {
                    String nameValue = ((PsiNameValuePair)o).getName();
                    return StringUtil.notNullize((String)nameValue, (String)"value");
                }
                return null;
            }
        });
    }
}

