/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.CharPattern;
import com.intellij.patterns.CollectionPattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.InitialPatternConditionPlus;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StringPattern;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardPatterns {
    private static final FalsePattern FALSE_PATTERN = new FalsePattern();

    @NotNull
    public static StringPattern string() {
        return StringPattern.STRING_PATTERN;
    }

    @NotNull
    public static CharPattern character() {
        return new CharPattern();
    }

    @NotNull
    public static <T> ObjectPattern.Capture<T> instanceOf(Class<T> aClass) {
        return new ObjectPattern.Capture<T>(aClass);
    }

    @SafeVarargs
    @NotNull
    public static <T> ElementPattern<T> instanceOf(Class<T> ... classes) {
        ElementPattern[] patterns = (ElementPattern[])ContainerUtil.map((Object[])classes, StandardPatterns::instanceOf, (Object[])new ElementPattern[0]);
        return StandardPatterns.or(patterns);
    }

    @NotNull
    public static <T> ElementPattern save(final Key<T> key) {
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                context.put(key, o);
                return true;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                builder.append("save(").append(key).append(")");
            }
        });
    }

    @NotNull
    public static ObjectPattern.Capture<Object> object() {
        return StandardPatterns.instanceOf(Object.class);
    }

    @NotNull
    public static <T> ObjectPattern.Capture<T> object(@NotNull T value) {
        return (ObjectPattern.Capture)StandardPatterns.instanceOf(value.getClass()).equalTo(value);
    }

    @NotNull
    public static <T> CollectionPattern<T> collection(Class<T> aClass) {
        return new CollectionPattern();
    }

    @NotNull
    public static ElementPattern get(final @NotNull @NonNls String key) {
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return Comparing.equal((Object)o, (Object)context.get((Object)key));
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                builder.append("get(").append(key).append(")");
            }
        });
    }

    @NotNull
    public static <T> CollectionPattern<T> collection() {
        return new CollectionPattern();
    }

    @SafeVarargs
    @NotNull
    public static <E> ElementPattern<E> or(final ElementPattern<? extends E> ... patterns) {
        return new ObjectPattern.Capture(new InitialPatternConditionPlus(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                for (ElementPattern pattern : patterns) {
                    if (!pattern.accepts(o, context)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                boolean first = true;
                for (ElementPattern pattern : patterns) {
                    if (!first) {
                        builder.append("\n").append(indent);
                    }
                    first = false;
                    pattern.getCondition().append(builder, indent + "  ");
                }
            }

            @Override
            public List<ElementPattern<?>> getPatterns() {
                return Arrays.asList(patterns);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    @NotNull
    public static <E> ElementPattern<E> and(ElementPattern<? extends E> ... patterns) {
        void var5_8;
        List initial = ContainerUtil.newSmartList();
        for (ElementPattern<E> elementPattern : patterns) {
            initial.add(elementPattern.getCondition().getInitialCondition());
        }
        ObjectPattern.Capture result = StandardPatterns.composeInitialConditions(initial);
        ElementPattern<? extends E>[] elementPatternArray = patterns;
        int n = elementPatternArray.length;
        boolean bl = false;
        while (var5_8 < n) {
            ElementPattern<E> elementPattern = elementPatternArray[var5_8];
            for (PatternCondition<? extends E> patternCondition : elementPattern.getCondition().getConditions()) {
                result = (ObjectPattern.Capture)result.with(patternCondition);
            }
            ++var5_8;
        }
        return result;
    }

    @NotNull
    private static <E> ObjectPattern.Capture<E> composeInitialConditions(final List<InitialPatternCondition> initial) {
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                for (InitialPatternCondition pattern : initial) {
                    if (pattern.accepts(o, context)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                boolean first = true;
                for (InitialPatternCondition pattern : initial) {
                    if (!first) {
                        builder.append("\n").append(indent);
                    }
                    first = false;
                    pattern.append(builder, indent + "  ");
                }
            }
        });
    }

    @NotNull
    public static <E> ObjectPattern.Capture<E> not(final ElementPattern<E> pattern) {
        return new ObjectPattern.Capture(new InitialPatternConditionPlus(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return !pattern.accepts(o, context);
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                pattern.getCondition().append(builder.append("not("), indent + "  ");
                builder.append(")");
            }

            @Override
            public List<ElementPattern<?>> getPatterns() {
                return Collections.singletonList(pattern);
            }
        });
    }

    @NotNull
    public static <T> ObjectPattern.Capture<T> optional(final ElementPattern<T> pattern) {
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                pattern.accepts(o, context);
                return true;
            }
        });
    }

    @NotNull
    public static <E> ElementPattern<E> alwaysFalse() {
        return FALSE_PATTERN;
    }

    private static final class FalsePattern
    implements ElementPattern {
        private FalsePattern() {
        }

        @Override
        public boolean accepts(@Nullable Object o) {
            return false;
        }

        @Override
        public boolean accepts(@Nullable Object o, ProcessingContext context) {
            return false;
        }

        public ElementPatternCondition getCondition() {
            return new ElementPatternCondition(new InitialPatternCondition(Object.class){

                @Override
                public boolean accepts(@Nullable Object o, ProcessingContext context) {
                    return false;
                }
            });
        }
    }
}

