/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.annotations.NotNull;

public abstract class LiteralTextEscaper<T extends PsiLanguageInjectionHost> {
    protected final T myHost;

    protected LiteralTextEscaper(@NotNull T host) {
        this.myHost = host;
    }

    public abstract boolean decode(@NotNull TextRange var1, @NotNull StringBuilder var2);

    public abstract int getOffsetInHost(int var1, @NotNull TextRange var2);

    @NotNull
    public TextRange getRelevantTextRange() {
        return TextRange.from((int)0, (int)this.myHost.getTextLength());
    }

    public abstract boolean isOneLine();

    public static <T extends PsiLanguageInjectionHost> LiteralTextEscaper<T> createSimple(T element) {
        return new LiteralTextEscaper<T>(element){

            @Override
            public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
                outChars.append(rangeInsideHost.substring(this.myHost.getText()));
                return true;
            }

            @Override
            public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
                return rangeInsideHost.getStartOffset() + offsetInDecoded;
            }

            @Override
            public boolean isOneLine() {
                return true;
            }
        };
    }
}

